/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import de.adorsys.psd2.xs2a.web.controller.PaymentController;
import java.util.EnumSet;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CreatePisAuthorizationAspect
extends AbstractLinkAspect<PaymentController> {
    private static final Logger log = LoggerFactory.getLogger(CreatePisAuthorizationAspect.class);

    public CreatePisAuthorizationAspect(ScaApproachResolver scaApproachResolver, MessageService messageService, AspspProfileServiceWrapper profileService) {
        super(scaApproachResolver, messageService, profileService);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.PaymentAuthorisationService.createPisAuthorization(..)) && args(paymentId, paymentType, paymentProduct, psuData)", returning="result", argNames="result,paymentId,paymentType,paymentProduct,psuData")
    public ResponseObject<Xs2aCreatePisAuthorisationResponse> createPisAuthorizationAspect(ResponseObject<Xs2aCreatePisAuthorisationResponse> result, String paymentId, PaymentType paymentType, String paymentProduct, PsuIdData psuData) {
        if (!result.hasError()) {
            Xs2aCreatePisAuthorisationResponse body = result.getBody();
            body.setLinks(this.buildLink(paymentType.getValue(), paymentProduct, paymentId, body.getAuthorisationId(), psuData));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    private Links buildLink(String paymentService, String paymentProduct, String paymentId, String authorizationId, PsuIdData psuData) {
        Links links = new Links();
        links.setSelf(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}", paymentService, paymentProduct, paymentId));
        links.setStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/status", paymentService, paymentProduct, paymentId));
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(this.scaApproachResolver.resolveScaApproach())) {
            String path = "/v1/{paymentService}/{paymentProduct}/{paymentId}/authorisations/{authorisationId}";
            if (psuData.isEmpty()) {
                links.setStartAuthorisationWithPsuIdentification(this.buildPath(path, paymentService, paymentProduct, paymentId, authorizationId));
            } else {
                links.setStartAuthorisationWithPsuAuthentication(this.buildPath(path, paymentService, paymentProduct, paymentId, authorizationId));
            }
        }
        return links;
    }
}

