/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CreateConsentRequestValidator {
    private final AspspProfileServiceWrapper aspspProfileService;
    private final ScaApproachResolver scaApproachResolver;

    public ValidationResult validateRequest(CreateConsentReq request) {
        if (this.isNotSupportedGlobalConsentForAllPsd2(request)) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.PARAMETER_NOT_SUPPORTED);
        }
        if (this.isNotSupportedBankOfferedConsent(request)) {
            return ValidationResult.invalid(ErrorType.AIS_405, MessageErrorCode.SERVICE_INVALID_405);
        }
        if (!this.isValidExpirationDate(request.getValidUntil())) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.PERIOD_INVALID);
        }
        if (this.isNotValidFrequencyPerDay(request.isRecurringIndicator(), request.getFrequencyPerDay())) {
            return ValidationResult.invalid(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, "Value of frequencyPerDay is not correct"));
        }
        if (this.isNotSupportedAvailableAccounts(request)) {
            return ValidationResult.invalid(ErrorType.AIS_405, MessageErrorCode.SERVICE_INVALID_405);
        }
        return ValidationResult.valid();
    }

    private boolean isNotSupportedGlobalConsentForAllPsd2(CreateConsentReq request) {
        return this.isConsentGlobal(request) && this.aspspProfileService.getAllPsd2Support() == false;
    }

    private boolean isNotSupportedBankOfferedConsent(CreateConsentReq request) {
        if (this.isNotEmptyAccess(request.getAccess()).booleanValue()) {
            return false;
        }
        if (this.scaApproachResolver.resolveScaApproach() == ScaApproach.EMBEDDED) {
            return true;
        }
        return !this.aspspProfileService.isBankOfferedConsentSupported();
    }

    private boolean isValidExpirationDate(LocalDate validUntil) {
        int consentLifetime = Math.abs(this.aspspProfileService.getConsentLifetime());
        return validUntil.isAfter(LocalDate.now()) && this.isValidConsentLifetime(consentLifetime, validUntil);
    }

    private boolean isConsentGlobal(CreateConsentReq request) {
        return this.isNotEmptyAccess(request.getAccess()) != false && request.getAccess().getAllPsd2() == AccountAccessType.ALL_ACCOUNTS;
    }

    private Boolean isNotEmptyAccess(Xs2aAccountAccess access) {
        return Optional.ofNullable(access).map(Xs2aAccountAccess::isNotEmpty).orElse(false);
    }

    private boolean isValidConsentLifetime(int consentLifetime, LocalDate validUntil) {
        return consentLifetime == 0 || validUntil.isBefore(LocalDate.now().plusDays(consentLifetime));
    }

    private boolean isNotValidFrequencyPerDay(boolean recurringIndicator, int frequencyPerDay) {
        return recurringIndicator ? frequencyPerDay <= 0 : frequencyPerDay != 1;
    }

    private boolean isNotSupportedAvailableAccounts(CreateConsentReq request) {
        if (Objects.isNull(request.getAccess().getAvailableAccounts())) {
            return false;
        }
        return !this.aspspProfileService.isAvailableAccountsConsentSupported();
    }

    @ConstructorProperties(value={"aspspProfileService", "scaApproachResolver"})
    public CreateConsentRequestValidator(AspspProfileServiceWrapper aspspProfileService, ScaApproachResolver scaApproachResolver) {
        this.aspspProfileService = aspspProfileService;
        this.scaApproachResolver = scaApproachResolver;
    }
}

