/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class SpiResponseToServiceAndErrorTypeMapper {
    private static final Map<SpiResponseStatus, Map<ServiceType, ErrorType>> spiResponseToServiceAndErrorType;

    public ErrorType mapToErrorType(SpiResponseStatus spiResponseStatus, ServiceType serviceType) {
        return Optional.ofNullable(spiResponseToServiceAndErrorType.get(spiResponseStatus)).map(m -> (ErrorType)((Object)((Object)m.get((Object)serviceType)))).orElse(null);
    }

    static {
        HashMap<ServiceType, ErrorType> technicalFailureServiceTypeToErrorType = new HashMap<ServiceType, ErrorType>();
        technicalFailureServiceTypeToErrorType.put(ServiceType.PIS, ErrorType.PIS_500);
        technicalFailureServiceTypeToErrorType.put(ServiceType.PIIS, ErrorType.PIIS_500);
        technicalFailureServiceTypeToErrorType.put(ServiceType.SB, ErrorType.SB_500);
        technicalFailureServiceTypeToErrorType.put(ServiceType.AIS, ErrorType.AIS_500);
        HashMap<ServiceType, ErrorType> unauthorizedFailureServiceTypeToErrorType = new HashMap<ServiceType, ErrorType>();
        unauthorizedFailureServiceTypeToErrorType.put(ServiceType.PIS, ErrorType.PIS_401);
        unauthorizedFailureServiceTypeToErrorType.put(ServiceType.PIIS, ErrorType.PIIS_401);
        unauthorizedFailureServiceTypeToErrorType.put(ServiceType.SB, ErrorType.SB_401);
        unauthorizedFailureServiceTypeToErrorType.put(ServiceType.AIS, ErrorType.AIS_401);
        HashMap<ServiceType, ErrorType> logicalFailureServiceTypeToErrorType = new HashMap<ServiceType, ErrorType>();
        logicalFailureServiceTypeToErrorType.put(ServiceType.PIS, ErrorType.PIS_400);
        logicalFailureServiceTypeToErrorType.put(ServiceType.PIIS, ErrorType.PIIS_400);
        logicalFailureServiceTypeToErrorType.put(ServiceType.SB, ErrorType.SB_400);
        logicalFailureServiceTypeToErrorType.put(ServiceType.AIS, ErrorType.AIS_400);
        HashMap<ServiceType, ErrorType> notSupportedFailureServiceTypeToErrorType = new HashMap<ServiceType, ErrorType>();
        notSupportedFailureServiceTypeToErrorType.put(ServiceType.PIS, ErrorType.PIS_400);
        notSupportedFailureServiceTypeToErrorType.put(ServiceType.PIIS, ErrorType.PIIS_400);
        notSupportedFailureServiceTypeToErrorType.put(ServiceType.SB, ErrorType.SB_400);
        notSupportedFailureServiceTypeToErrorType.put(ServiceType.AIS, ErrorType.AIS_400);
        spiResponseToServiceAndErrorType = new HashMap<SpiResponseStatus, Map<ServiceType, ErrorType>>();
        spiResponseToServiceAndErrorType.put(SpiResponseStatus.TECHNICAL_FAILURE, technicalFailureServiceTypeToErrorType);
        spiResponseToServiceAndErrorType.put(SpiResponseStatus.UNAUTHORIZED_FAILURE, unauthorizedFailureServiceTypeToErrorType);
        spiResponseToServiceAndErrorType.put(SpiResponseStatus.LOGICAL_FAILURE, logicalFailureServiceTypeToErrorType);
        spiResponseToServiceAndErrorType.put(SpiResponseStatus.NOT_SUPPORTED, notSupportedFailureServiceTypeToErrorType);
    }
}

