/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.AisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountAccessMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.AisEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.CreateConsentRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiateAisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ConsentService {
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final AisConsentDataService aisConsentDataService;
    private final AisScaAuthorisationServiceResolver aisScaAuthorisationServiceResolver;
    private final TppService tppService;
    private final AisEndpointAccessCheckerService endpointAccessCheckerService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final AisConsentSpi aisConsentSpi;
    private final CreateConsentRequestValidator createConsentRequestValidator;
    private final Xs2aEventService xs2aEventService;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;
    private final SpiErrorMapper spiErrorMapper;
    private final ScaApproachResolver scaApproachResolver;
    private final AspspProfileServiceWrapper aspspProfileService;
    private static final String MESSAGE_ERROR_NO_PSU = "Please provide the PSU identification data";

    public ResponseObject<CreateConsentResponse> createAccountConsentsWithResponse(CreateConsentReq request, PsuIdData psuData, boolean explicitPreferred, TppRedirectUri tppRedirectUri) {
        this.xs2aEventService.recordTppRequest(EventType.CREATE_AIS_CONSENT_REQUEST_RECEIVED, request);
        if (this.aspspProfileService.isPsuInInitialRequestMandated() && psuData.isEmpty()) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, MESSAGE_ERROR_NO_PSU)).build();
        }
        ValidationResult validationResult = this.createConsentRequestValidator.validateRequest(request);
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (request.isGlobalOrAllAccountsAccessConsent()) {
            request.setAccess(this.getAccessForGlobalOrAllAvailableAccountsConsent(request));
        }
        TppInfo tppInfo = this.tppService.getTppInfo();
        tppInfo.setTppRedirectUri(tppRedirectUri);
        String consentId = this.aisConsentService.createConsent(request, psuData, tppInfo);
        if (StringUtils.isBlank((CharSequence)consentId)) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = this.getInitialAccountConsent(consentId);
        SpiContextData contextData = this.spiContextDataProvider.provide(psuData, tppInfo);
        SpiResponse initiateAisConsentSpiResponse = this.aisConsentSpi.initiateAisConsent(contextData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(initiateAisConsentSpiResponse.getAspspConsentData());
        if (initiateAisConsentSpiResponse.hasError()) {
            this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.REJECTED);
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(initiateAisConsentSpiResponse, ServiceType.AIS))).build();
        }
        SpiInitiateAisConsentResponse spiResponsePayload = (SpiInitiateAisConsentResponse)initiateAisConsentSpiResponse.getPayload();
        boolean multilevelScaRequired = spiResponsePayload.isMultilevelScaRequired();
        this.updateMultilevelSca(consentId, multilevelScaRequired);
        Optional<Xs2aAccountAccess> xs2aAccountAccess = this.spiToXs2aAccountAccessMapper.mapToAccountAccess(spiResponsePayload.getAccountAccess());
        xs2aAccountAccess.ifPresent(accountAccess -> this.accountReferenceUpdater.rewriteAccountAccess(consentId, (Xs2aAccountAccess)accountAccess));
        ResponseObject<CreateConsentResponse> createConsentResponseObject = ResponseObject.builder().body(new CreateConsentResponse(ConsentStatus.RECEIVED.getValue(), consentId, null, null, null, null, multilevelScaRequired)).build();
        if (this.isEmbeddedOrRedirectScaApproach() && this.authorisationMethodDecider.isImplicitMethod(explicitPreferred, multilevelScaRequired)) {
            this.proceedImplicitCaseForCreateConsent(createConsentResponseObject.getBody(), psuData, consentId);
        }
        return createConsentResponseObject;
    }

    private void updateMultilevelSca(String consentId, boolean multilevelScaRequired) {
        if (multilevelScaRequired) {
            this.aisConsentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
        }
    }

    public ResponseObject<ConsentStatusResponse> getAccountConsentsStatusById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_AIS_CONSENT_STATUS_REQUEST_RECEIVED);
        AccountConsent validatedAccountConsent = this.getValidatedAccountConsent(consentId);
        Optional<ConsentStatus> consentStatus = Optional.ofNullable(validatedAccountConsent).map(AccountConsent::getConsentStatus);
        ResponseObject.ResponseBuilder<Object> responseBuilder = ResponseObject.builder();
        responseBuilder = consentStatus.isPresent() ? responseBuilder.body(new ConsentStatusResponse(consentStatus.get())) : responseBuilder.fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400));
        return responseBuilder.build();
    }

    public ResponseObject<Void> deleteAccountConsentsById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.DELETE_AIS_CONSENT_REQUEST_RECEIVED);
        AccountConsent accountConsent = this.getValidatedAccountConsent(consentId);
        if (accountConsent != null) {
            SpiContextData contextData = this.getSpiContextData(accountConsent.getPsuIdDataList());
            SpiResponse revokeAisConsentResponse = this.aisConsentSpi.revokeAisConsent(contextData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
            this.aisConsentDataService.updateAspspConsentData(revokeAisConsentResponse.getAspspConsentData());
            if (revokeAisConsentResponse.hasError()) {
                return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(revokeAisConsentResponse, ServiceType.AIS))).build();
            }
            ConsentStatus newConsentStatus = accountConsent.getConsentStatus() == ConsentStatus.RECEIVED ? ConsentStatus.REJECTED : ConsentStatus.TERMINATED_BY_TPP;
            this.aisConsentService.updateConsentStatus(consentId, newConsentStatus);
            return ResponseObject.builder().build();
        }
        return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
    }

    public ResponseObject<AccountConsent> getAccountConsentById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_AIS_CONSENT_REQUEST_RECEIVED);
        AccountConsent consent = this.getInitialAccountConsent(consentId);
        return consent == null ? ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build() : ResponseObject.builder().body(consent).build();
    }

    public ResponseObject<AccountConsent> getValidatedConsent(String consentId, boolean withBalance) {
        AccountConsent accountConsent = this.getValidatedAccountConsent(consentId);
        if (accountConsent == null) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        if (LocalDate.now().compareTo(accountConsent.getValidUntil()) >= 0) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        ConsentStatus consentStatus = accountConsent.getConsentStatus();
        if (consentStatus != ConsentStatus.VALID) {
            MessageErrorCode messageErrorCode = consentStatus == ConsentStatus.RECEIVED ? MessageErrorCode.CONSENT_INVALID : MessageErrorCode.CONSENT_EXPIRED;
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(messageErrorCode)).build();
        }
        if (accountConsent.isAccessExceeded()) {
            return ResponseObject.builder().fail(ErrorType.AIS_429, TppMessageInformation.of(MessageErrorCode.ACCESS_EXCEEDED)).build();
        }
        return ResponseObject.builder().body(accountConsent).build();
    }

    public ResponseObject<AccountConsent> getValidatedConsent(String consentId) {
        return this.getValidatedConsent(consentId, false);
    }

    public ResponseObject<CreateConsentAuthorizationResponse> createConsentAuthorizationWithResponse(PsuIdData psuData, String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.START_AIS_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        AccountConsent accountConsent = this.getValidatedAccountConsent(consentId);
        if (accountConsent != null && accountConsent.isExpired()) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        AisAuthorizationService service = (AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getService();
        return service.createConsentAuthorization(psuData, consentId).map(resp -> ResponseObject.builder().body((CreateConsentAuthorizationResponse)resp).build()).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400))::build);
    }

    public ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuData(UpdateConsentPsuDataReq updatePsuData) {
        this.xs2aEventService.recordAisTppRequest(updatePsuData.getConsentId(), EventType.UPDATE_AIS_CONSENT_PSU_DATA_REQUEST_RECEIVED, updatePsuData);
        if (!this.endpointAccessCheckerService.isEndpointAccessible(updatePsuData.getAuthorizationId(), updatePsuData.getConsentId())) {
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.SERVICE_BLOCKED)).build();
        }
        AccountConsent accountConsent = this.getValidatedAccountConsent(updatePsuData.getConsentId());
        if (accountConsent != null && accountConsent.isExpired()) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        return Optional.ofNullable(((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getService()).getAccountConsentAuthorizationById(updatePsuData.getAuthorizationId(), updatePsuData.getConsentId())).map(conAuth -> this.getUpdateConsentPsuDataResponse(updatePsuData, (AccountConsentAuthorization)conAuth)).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
    }

    private ResponseObject<UpdateConsentPsuDataResponse> getUpdateConsentPsuDataResponse(UpdateConsentPsuDataReq updatePsuData, AccountConsentAuthorization consentAuthorization) {
        UpdateConsentPsuDataResponse response = ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getService()).updateConsentPsuData(updatePsuData, consentAuthorization);
        return Optional.ofNullable(response).map(s -> Optional.ofNullable(s.getMessageError()).map(e -> ResponseObject.builder().fail((MessageError)e).build()).orElseGet(ResponseObject.builder().body(response)::build)).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR))::build);
    }

    public ResponseObject<Xs2aAuthorisationSubResources> getConsentInitiationAuthorisations(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        return ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getService()).getAuthorisationSubResources(consentId).map(resp -> ResponseObject.builder().body((Xs2aAuthorisationSubResources)resp).build()).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
    }

    public ResponseObject<ScaStatus> getConsentAuthorisationScaStatus(String consentId, String authorisationId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_CONSENT_SCA_STATUS_REQUEST_RECEIVED);
        Optional<ScaStatus> scaStatus = ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getService()).getAuthorisationScaStatus(consentId, authorisationId);
        if (!scaStatus.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        return ResponseObject.builder().body(scaStatus.get()).build();
    }

    public boolean isValidAccountByAccess(String resourceId, List<AccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> a.getResourceId().equals(resourceId));
    }

    private Xs2aAccountAccess getAccessForGlobalOrAllAvailableAccountsConsent(CreateConsentReq request) {
        return new Xs2aAccountAccess(new ArrayList<AccountReference>(), new ArrayList<AccountReference>(), new ArrayList<AccountReference>(), request.getAccess().getAvailableAccounts(), request.getAccess().getAllPsd2());
    }

    private AccountConsent getValidatedAccountConsent(String consentId) {
        return Optional.ofNullable(this.aisConsentService.getAccountConsentById(consentId)).filter(consent -> this.tppService.getTppId().equals(consent.getTppInfo().getAuthorisationNumber())).orElse(null);
    }

    private AccountConsent getInitialAccountConsent(String consentId) {
        return Optional.ofNullable(this.aisConsentService.getInitialAccountConsentById(consentId)).filter(consent -> this.tppService.getTppId().equals(consent.getTppInfo().getAuthorisationNumber())).orElse(null);
    }

    private void proceedImplicitCaseForCreateConsent(CreateConsentResponse response, PsuIdData psuData, String consentId) {
        ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getService()).createConsentAuthorization(psuData, consentId).ifPresent(a -> response.setAuthorizationId(a.getAuthorizationId()));
    }

    private boolean isEmbeddedOrRedirectScaApproach() {
        return EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.REDIRECT).contains(this.scaApproachResolver.resolveScaApproach());
    }

    private SpiContextData getSpiContextData(List<PsuIdData> psuIdDataList) {
        return this.spiContextDataProvider.provideWithPsuIdData(CollectionUtils.isNotEmpty(psuIdDataList) ? psuIdDataList.get(0) : null);
    }

    @ConstructorProperties(value={"aisConsentMapper", "spiToXs2aAccountAccessMapper", "aisConsentService", "aisConsentDataService", "aisScaAuthorisationServiceResolver", "tppService", "endpointAccessCheckerService", "spiContextDataProvider", "authorisationMethodDecider", "aisConsentSpi", "createConsentRequestValidator", "xs2aEventService", "accountReferenceUpdater", "spiErrorMapper", "scaApproachResolver", "aspspProfileService"})
    public ConsentService(Xs2aAisConsentMapper aisConsentMapper, SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper, Xs2aAisConsentService aisConsentService, AisConsentDataService aisConsentDataService, AisScaAuthorisationServiceResolver aisScaAuthorisationServiceResolver, TppService tppService, AisEndpointAccessCheckerService endpointAccessCheckerService, SpiContextDataProvider spiContextDataProvider, AuthorisationMethodDecider authorisationMethodDecider, AisConsentSpi aisConsentSpi, CreateConsentRequestValidator createConsentRequestValidator, Xs2aEventService xs2aEventService, AccountReferenceInConsentUpdater accountReferenceUpdater, SpiErrorMapper spiErrorMapper, ScaApproachResolver scaApproachResolver, AspspProfileServiceWrapper aspspProfileService) {
        this.aisConsentMapper = aisConsentMapper;
        this.spiToXs2aAccountAccessMapper = spiToXs2aAccountAccessMapper;
        this.aisConsentService = aisConsentService;
        this.aisConsentDataService = aisConsentDataService;
        this.aisScaAuthorisationServiceResolver = aisScaAuthorisationServiceResolver;
        this.tppService = tppService;
        this.endpointAccessCheckerService = endpointAccessCheckerService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.aisConsentSpi = aisConsentSpi;
        this.createConsentRequestValidator = createConsentRequestValidator;
        this.xs2aEventService = xs2aEventService;
        this.accountReferenceUpdater = accountReferenceUpdater;
        this.spiErrorMapper = spiErrorMapper;
        this.scaApproachResolver = scaApproachResolver;
        this.aspspProfileService = aspspProfileService;
    }
}

