/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.ConsentApi;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.service.AccountReferenceValidationService;
import de.adorsys.psd2.xs2a.service.ConsentService;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ResponseErrorMapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.mapper.AuthorisationMapper;
import de.adorsys.psd2.xs2a.web.mapper.ConsentModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.TppRedirectUriMapper;
import de.adorsys.psd2.xs2a.web.validator.ConsentControllerHeadersValidationService;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="v1", description="Provides access to the account information", tags={"Account Information Service (AIS)"})
public class ConsentController
implements ConsentApi {
    private static final Logger log = LoggerFactory.getLogger(ConsentController.class);
    private final ConsentService consentService;
    private final ResponseMapper responseMapper;
    private final AccountReferenceValidationService referenceValidationService;
    private final ConsentControllerHeadersValidationService headersValidationService;
    private final ConsentModelMapper consentModelMapper;
    private final AuthorisationMapper authorisationMapper;
    private final TppRedirectUriMapper tppRedirectUriMapper;
    private final ResponseErrorMapper responseErrorMapper;

    public ResponseEntity createConsent(UUID xRequestID, Consents body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, boolean tpPExplicitAuthorisationPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Object> createConsentResponse;
        ResponseObject accountReferenceValidationResponse;
        ValidationResult consentValidationResult = this.headersValidationService.validateCreateConsent();
        if (consentValidationResult.isNotValid()) {
            return this.responseErrorMapper.generateErrorResponse(consentValidationResult.getMessageError());
        }
        CreateConsentReq createConsent = this.consentModelMapper.mapToCreateConsentReq(body);
        Set<AccountReference> references = createConsent.getAccountReferences();
        ResponseObject responseObject = accountReferenceValidationResponse = references.isEmpty() ? ResponseObject.builder().build() : this.referenceValidationService.validateAccountReferences(createConsent.getAccountReferences());
        if (accountReferenceValidationResponse.hasError()) {
            createConsentResponse = ResponseObject.builder().fail(accountReferenceValidationResponse.getError()).build();
        } else {
            PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
            TppRedirectUri tppRedirectUri = this.tppRedirectUriMapper.mapToTppRedirectUri(tpPRedirectURI, tpPNokRedirectURI);
            createConsentResponse = this.consentService.createAccountConsentsWithResponse(createConsent, psuData, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred), tppRedirectUri);
        }
        return createConsentResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(createConsentResponse.getError()) : this.responseMapper.created(createConsentResponse, this.consentModelMapper::mapToConsentsResponse201);
    }

    public ResponseEntity getConsentStatus(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<ConsentStatusResponse> accountConsentsStatusByIdResponse = this.consentService.getAccountConsentsStatusById(consentId);
        return accountConsentsStatusByIdResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(accountConsentsStatusByIdResponse.getError()) : this.responseMapper.ok(accountConsentsStatusByIdResponse, this.consentModelMapper::mapToConsentStatusResponse200);
    }

    public ResponseEntity startConsentAuthorisation(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        ResponseObject<CreateConsentAuthorizationResponse> consentAuthorizationWithResponse = this.consentService.createConsentAuthorizationWithResponse(psuData, consentId);
        return consentAuthorizationWithResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(consentAuthorizationWithResponse.getError()) : this.responseMapper.created(consentAuthorizationWithResponse, this.authorisationMapper::mapToStartScaProcessResponse);
    }

    public ResponseEntity updateConsentsPsuData(UUID xRequestID, String consentId, String authorisationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        UpdateConsentPsuDataReq updatePsuDataRequest = this.consentModelMapper.mapToUpdatePsuData(psuData, consentId, authorisationId, (Map)body);
        ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuDataResponse = this.consentService.updateConsentPsuData(updatePsuDataRequest);
        return updateConsentPsuDataResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(updateConsentPsuDataResponse.getError()) : this.responseMapper.ok(updateConsentPsuDataResponse, this.consentModelMapper::mapToUpdatePsuAuthenticationResponse);
    }

    public ResponseEntity getConsentScaStatus(String consentId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<ScaStatus> consentAuthorisationScaStatusResponse = this.consentService.getConsentAuthorisationScaStatus(consentId, authorisationId);
        return consentAuthorisationScaStatusResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(consentAuthorisationScaStatusResponse.getError()) : this.responseMapper.ok(consentAuthorisationScaStatusResponse, this.authorisationMapper::mapToScaStatusResponse);
    }

    public ResponseEntity getConsentAuthorisation(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aAuthorisationSubResources> consentInitiationAuthorisationsResponse = this.consentService.getConsentInitiationAuthorisations(consentId);
        return consentInitiationAuthorisationsResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(consentInitiationAuthorisationsResponse.getError()) : this.responseMapper.ok(consentInitiationAuthorisationsResponse, this.consentModelMapper::mapToAuthorisations);
    }

    public ResponseEntity getConsentInformation(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<AccountConsent> accountConsentByIdResponse = this.consentService.getAccountConsentById(consentId);
        return accountConsentByIdResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(accountConsentByIdResponse.getError()) : this.responseMapper.ok(accountConsentByIdResponse, this.consentModelMapper::mapToConsentInformationResponse200Json);
    }

    public ResponseEntity deleteConsent(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Void> response = this.consentService.deleteAccountConsentsById(consentId);
        return response.hasError() ? this.responseErrorMapper.generateErrorResponse(response.getError()) : this.responseMapper.delete(response);
    }

    @ConstructorProperties(value={"consentService", "responseMapper", "referenceValidationService", "headersValidationService", "consentModelMapper", "authorisationMapper", "tppRedirectUriMapper", "responseErrorMapper"})
    public ConsentController(ConsentService consentService, ResponseMapper responseMapper, AccountReferenceValidationService referenceValidationService, ConsentControllerHeadersValidationService headersValidationService, ConsentModelMapper consentModelMapper, AuthorisationMapper authorisationMapper, TppRedirectUriMapper tppRedirectUriMapper, ResponseErrorMapper responseErrorMapper) {
        this.consentService = consentService;
        this.responseMapper = responseMapper;
        this.referenceValidationService = referenceValidationService;
        this.headersValidationService = headersValidationService;
        this.consentModelMapper = consentModelMapper;
        this.authorisationMapper = authorisationMapper;
        this.tppRedirectUriMapper = tppRedirectUriMapper;
        this.responseErrorMapper = responseErrorMapper;
    }
}

