/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class GetCommonPaymentByIdResponseValidator {
    public ValidationResult validateRequest(@Nullable PisCommonPaymentResponse pisCommonPayment, PaymentType paymentType, String paymentProduct) {
        if (pisCommonPayment == null) {
            return ValidationResult.invalid(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, "Payment not found"));
        }
        if (this.isPaymentTypeIncorrect(paymentType, pisCommonPayment)) {
            return ValidationResult.invalid(ErrorType.PIS_405, TppMessageInformation.of(MessageErrorCode.SERVICE_INVALID_405, "Service invalid for addressed payment"));
        }
        if (this.isPaymentProductIncorrect(paymentProduct, pisCommonPayment)) {
            return ValidationResult.invalid(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.PRODUCT_INVALID, "Payment product invalid for addressed payment"));
        }
        return ValidationResult.valid();
    }

    private boolean isPaymentTypeIncorrect(PaymentType paymentType, PisCommonPaymentResponse commonPaymentResponse) {
        return commonPaymentResponse.getPaymentType() != paymentType;
    }

    private boolean isPaymentProductIncorrect(String paymentProduct, PisCommonPaymentResponse commonPaymentResponse) {
        return !commonPaymentResponse.getPaymentProduct().equalsIgnoreCase(paymentProduct);
    }
}

