/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.code.Xs2aFrequencyCode;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAddressMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aPeriodicPaymentMapper {
    private final SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    private final SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    private final SpiToXs2aAddressMapper spiToXs2aAddressMapper;

    public PeriodicPayment mapToXs2aPeriodicPayment(SpiPeriodicPayment payment) {
        return Optional.ofNullable(payment).map(p -> {
            PeriodicPayment periodic = new PeriodicPayment();
            periodic.setPaymentId(p.getPaymentId());
            periodic.setEndToEndIdentification(p.getEndToEndIdentification());
            periodic.setDebtorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(p.getDebtorAccount()).orElse(null));
            periodic.setInstructedAmount(this.spiToXs2aAmountMapper.mapToXs2aAmount(p.getInstructedAmount()));
            periodic.setCreditorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(p.getCreditorAccount()).orElse(null));
            periodic.setCreditorAgent(p.getCreditorAgent());
            periodic.setCreditorName(p.getCreditorName());
            periodic.setCreditorAddress(this.spiToXs2aAddressMapper.mapToAddress(p.getCreditorAddress()));
            periodic.setRemittanceInformationUnstructured(p.getRemittanceInformationUnstructured());
            periodic.setStartDate(p.getStartDate());
            periodic.setEndDate(p.getEndDate());
            periodic.setExecutionRule(p.getExecutionRule());
            periodic.setFrequency(Xs2aFrequencyCode.valueOf(p.getFrequency().name()));
            periodic.setDayOfExecution(p.getDayOfExecution());
            periodic.setTransactionStatus(payment.getPaymentStatus());
            return periodic;
        }).orElse(null);
    }

    @ConstructorProperties(value={"spiToXs2aAccountReferenceMapper", "spiToXs2aAmountMapper", "spiToXs2aAddressMapper"})
    public SpiToXs2aPeriodicPaymentMapper(SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper, SpiToXs2aAmountMapper spiToXs2aAmountMapper, SpiToXs2aAddressMapper spiToXs2aAddressMapper) {
        this.spiToXs2aAccountReferenceMapper = spiToXs2aAccountReferenceMapper;
        this.spiToXs2aAmountMapper = spiToXs2aAmountMapper;
        this.spiToXs2aAddressMapper = spiToXs2aAddressMapper;
    }
}

