/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class SpiResponseStatusToXs2aMessageErrorCodeMapper {
    private static final Map<SpiResponseStatus, MessageErrorCode> spiResponseStatusToMessageErrorCode = new HashMap<SpiResponseStatus, MessageErrorCode>();

    public MessageErrorCode mapToMessageErrorCode(SpiResponseStatus responseStatus) {
        return spiResponseStatusToMessageErrorCode.getOrDefault(responseStatus, MessageErrorCode.INTERNAL_SERVER_ERROR);
    }

    public String mapToTppMessage(List<String> messages) {
        if (CollectionUtils.isNotEmpty(messages)) {
            return String.join((CharSequence)", ", messages);
        }
        return null;
    }

    static {
        spiResponseStatusToMessageErrorCode.put(SpiResponseStatus.TECHNICAL_FAILURE, MessageErrorCode.INTERNAL_SERVER_ERROR);
        spiResponseStatusToMessageErrorCode.put(SpiResponseStatus.UNAUTHORIZED_FAILURE, MessageErrorCode.PSU_CREDENTIALS_INVALID);
        spiResponseStatusToMessageErrorCode.put(SpiResponseStatus.LOGICAL_FAILURE, MessageErrorCode.FORMAT_ERROR);
        spiResponseStatusToMessageErrorCode.put(SpiResponseStatus.NOT_SUPPORTED, MessageErrorCode.PARAMETER_NOT_SUPPORTED);
    }
}

