/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiResponseStatusToXs2aMessageErrorCodeMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiResponseToServiceAndErrorTypeMapper;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class SpiErrorMapper {
    private final SpiResponseStatusToXs2aMessageErrorCodeMapper spiToXs2aMessageErrorCodeMapper;
    private final SpiResponseToServiceAndErrorTypeMapper spiToServiceAndErrorTypeMapper;

    public ErrorHolder mapToErrorHolder(SpiResponse<?> spiResponse, ServiceType serviceType) {
        SpiResponseStatus responseStatus = spiResponse.getResponseStatus();
        return ErrorHolder.builder(this.spiToXs2aMessageErrorCodeMapper.mapToMessageErrorCode(responseStatus)).errorType(this.spiToServiceAndErrorTypeMapper.mapToErrorType(responseStatus, serviceType)).messages(spiResponse.getMessages()).build();
    }

    @ConstructorProperties(value={"spiToXs2aMessageErrorCodeMapper", "spiToServiceAndErrorTypeMapper"})
    public SpiErrorMapper(SpiResponseStatusToXs2aMessageErrorCodeMapper spiToXs2aMessageErrorCodeMapper, SpiResponseToServiceAndErrorTypeMapper spiToServiceAndErrorTypeMapper) {
        this.spiToXs2aMessageErrorCodeMapper = spiToXs2aMessageErrorCodeMapper;
        this.spiToServiceAndErrorTypeMapper = spiToServiceAndErrorTypeMapper;
    }
}

