/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.sb;

import de.adorsys.psd2.model.Error403NGSB;
import de.adorsys.psd2.model.MessageCode403SB;
import de.adorsys.psd2.model.TppMessage403SB;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SB403ErrorMapper
extends Psd2ErrorMapper<MessageError, Error403NGSB> {
    @Override
    public Function<MessageError, Error403NGSB> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.FORBIDDEN;
    }

    private Error403NGSB mapToPsd2Error(MessageError messageError) {
        return new Error403NGSB().tppMessages(this.mapToTppMessage403SB(messageError.getTppMessages()));
    }

    private List<TppMessage403SB> mapToTppMessage403SB(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage403SB().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode403SB.fromValue((String)m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

