/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.sb;

import de.adorsys.psd2.model.Error401NGSB;
import de.adorsys.psd2.model.MessageCode401SB;
import de.adorsys.psd2.model.TppMessage401SB;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SB401ErrorMapper
extends Psd2ErrorMapper<MessageError, Error401NGSB> {
    @Override
    public Function<MessageError, Error401NGSB> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.UNAUTHORIZED;
    }

    private Error401NGSB mapToPsd2Error(MessageError messageError) {
        return new Error401NGSB().tppMessages(this.mapToTppMessage400SB(messageError.getTppMessages()));
    }

    private List<TppMessage401SB> mapToTppMessage400SB(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage401SB().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode401SB.fromValue((String)m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

