/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.sb;

import de.adorsys.psd2.model.Error400NGSB;
import de.adorsys.psd2.model.MessageCode400SB;
import de.adorsys.psd2.model.TppMessage400SB;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SB400ErrorMapper
extends Psd2ErrorMapper<MessageError, Error400NGSB> {
    @Override
    public Function<MessageError, Error400NGSB> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.BAD_REQUEST;
    }

    private Error400NGSB mapToPsd2Error(MessageError messageError) {
        return new Error400NGSB().tppMessages(this.mapToTppMessage400SB(messageError.getTppMessages()));
    }

    private List<TppMessage400SB> mapToTppMessage400SB(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage400SB().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode400SB.fromValue((String)m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

