/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis;

import de.adorsys.psd2.consent.api.CmsAuthorisationType;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.GetPisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.config.factory.PisScaStageAuthorisationFactory;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.authorization.pis.stage.PisScaStage;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisCommonPaymentMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PisAuthorisationService {
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;
    private final PisScaStageAuthorisationFactory pisScaStageAuthorisationFactory;
    private final Xs2aPisCommonPaymentMapper pisCommonPaymentMapper;
    private final ScaApproachResolver scaApproachResolver;

    public CreatePisAuthorisationResponse createPisAuthorisation(String paymentId, PsuIdData psuData) {
        CreatePisAuthorisationRequest request = new CreatePisAuthorisationRequest(CmsAuthorisationType.CREATED, psuData, this.scaApproachResolver.resolveScaApproach());
        return this.pisCommonPaymentServiceEncrypted.createAuthorization(paymentId, request).orElse(null);
    }

    public Xs2aUpdatePisCommonPaymentPsuDataResponse updatePisAuthorisation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, ScaApproach scaApproach) {
        GetPisAuthorisationResponse response = this.pisCommonPaymentServiceEncrypted.getPisAuthorisationById(request.getAuthorisationId()).orElse(null);
        PisScaStage service = (PisScaStage)this.pisScaStageAuthorisationFactory.getService("PIS_" + scaApproach.name() + "_" + response.getScaStatus().name());
        Xs2aUpdatePisCommonPaymentPsuDataResponse stageResponse = (Xs2aUpdatePisCommonPaymentPsuDataResponse)service.apply(request, response);
        if (!stageResponse.hasError()) {
            this.doUpdatePisAuthorisation(this.pisCommonPaymentMapper.mapToCmsUpdateCommonPaymentPsuDataReq(request, stageResponse));
        }
        return stageResponse;
    }

    public Xs2aUpdatePisCommonPaymentPsuDataResponse updatePisCancellationAuthorisation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, ScaApproach scaApproach) {
        GetPisAuthorisationResponse response = this.pisCommonPaymentServiceEncrypted.getPisCancellationAuthorisationById(request.getAuthorisationId()).orElse(null);
        PisScaStage service = (PisScaStage)this.pisScaStageAuthorisationFactory.getService("PIS_CANCELLATION_" + scaApproach.name() + "_" + response.getScaStatus().name());
        Xs2aUpdatePisCommonPaymentPsuDataResponse stageResponse = (Xs2aUpdatePisCommonPaymentPsuDataResponse)service.apply(request, response);
        if (!stageResponse.hasError()) {
            this.doUpdatePisCancellationAuthorisation(this.pisCommonPaymentMapper.mapToCmsUpdateCommonPaymentPsuDataReq(request, stageResponse));
        }
        return stageResponse;
    }

    public void doUpdatePisAuthorisation(UpdatePisCommonPaymentPsuDataRequest request) {
        this.pisCommonPaymentServiceEncrypted.updatePisAuthorisation(request.getAuthorizationId(), request);
    }

    public void doUpdatePisCancellationAuthorisation(UpdatePisCommonPaymentPsuDataRequest request) {
        this.pisCommonPaymentServiceEncrypted.updatePisCancellationAuthorisation(request.getAuthorizationId(), request);
    }

    public CreatePisAuthorisationResponse createPisAuthorisationCancellation(String paymentId, PsuIdData psuData) {
        CreatePisAuthorisationRequest request = new CreatePisAuthorisationRequest(CmsAuthorisationType.CANCELLED, psuData, this.scaApproachResolver.resolveScaApproach());
        return this.pisCommonPaymentServiceEncrypted.createAuthorizationCancellation(paymentId, request).orElse(null);
    }

    public Optional<List<String>> getCancellationAuthorisationSubResources(String paymentId) {
        return this.pisCommonPaymentServiceEncrypted.getAuthorisationsByPaymentId(paymentId, CmsAuthorisationType.CANCELLED);
    }

    public Optional<List<String>> getAuthorisationSubResources(String paymentId) {
        return this.pisCommonPaymentServiceEncrypted.getAuthorisationsByPaymentId(paymentId, CmsAuthorisationType.CREATED);
    }

    public Optional<ScaStatus> getAuthorisationScaStatus(String paymentId, String authorisationId) {
        return this.pisCommonPaymentServiceEncrypted.getAuthorisationScaStatus(paymentId, authorisationId, CmsAuthorisationType.CREATED);
    }

    public Optional<ScaStatus> getCancellationAuthorisationScaStatus(String paymentId, String cancellationId) {
        return this.pisCommonPaymentServiceEncrypted.getAuthorisationScaStatus(paymentId, cancellationId, CmsAuthorisationType.CANCELLED);
    }

    @ConstructorProperties(value={"pisCommonPaymentServiceEncrypted", "pisScaStageAuthorisationFactory", "pisCommonPaymentMapper", "scaApproachResolver"})
    public PisAuthorisationService(PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted, PisScaStageAuthorisationFactory pisScaStageAuthorisationFactory, Xs2aPisCommonPaymentMapper pisCommonPaymentMapper, ScaApproachResolver scaApproachResolver) {
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
        this.pisScaStageAuthorisationFactory = pisScaStageAuthorisationFactory;
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.scaApproachResolver = scaApproachResolver;
    }
}

