/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.domain.RequestData;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class RequestProviderService {
    private static final String TPP_REDIRECT_PREFERRED_HEADER = "tpp-redirect-preferred";
    private static final String X_REQUEST_ID_HEADER = "x-request-id";
    private final HttpServletRequest httpServletRequest;

    public boolean resolveTppRedirectPreferred() {
        Map<String, String> headers = this.getRequestData().getHeaders();
        if (headers == null || !headers.containsKey(TPP_REDIRECT_PREFERRED_HEADER)) {
            return false;
        }
        return Boolean.valueOf(headers.get(TPP_REDIRECT_PREFERRED_HEADER));
    }

    public RequestData getRequestData() {
        String uri = this.httpServletRequest.getRequestURI();
        UUID requestId = UUID.fromString(this.httpServletRequest.getHeader(X_REQUEST_ID_HEADER));
        String ip = this.httpServletRequest.getRemoteAddr();
        Map<String, String> headers = this.getRequestHeaders(this.httpServletRequest);
        return new RequestData(uri, requestId, ip, headers);
    }

    public UUID getRequestId() {
        return this.getRequestData().getRequestId();
    }

    private Map<String, String> getRequestHeaders(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
    }

    @ConstructorProperties(value={"httpServletRequest"})
    public RequestProviderService(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }
}

