/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.service.PiisConsentService;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationRequest;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationResponse;
import de.adorsys.psd2.xs2a.domain.fund.PiisConsentValidationResult;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.FundsConfirmationConsentDataService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aFundsConfirmationMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiFundsConfirmationRequestMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.PiisConsentValidationService;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationRequest;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.FundsConfirmationSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FundsConfirmationService {
    private static final Logger log = LoggerFactory.getLogger(FundsConfirmationService.class);
    private final AspspProfileServiceWrapper profileService;
    private final FundsConfirmationSpi fundsConfirmationSpi;
    private final FundsConfirmationConsentDataService fundsConfirmationConsentDataService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aToSpiFundsConfirmationRequestMapper xs2aToSpiFundsConfirmationRequestMapper;
    private final SpiToXs2aFundsConfirmationMapper spiToXs2aFundsConfirmationMapper;
    private final PiisConsentValidationService piisConsentValidationService;
    private final PiisConsentService piisConsentService;
    private final Xs2aEventService xs2aEventService;
    private final SpiErrorMapper spiErrorMapper;

    public ResponseObject<FundsConfirmationResponse> fundsConfirmation(FundsConfirmationRequest request) {
        AspspConsentData aspspConsentData;
        PsuIdData psuIdData;
        FundsConfirmationResponse response;
        this.xs2aEventService.recordTppRequest(EventType.FUNDS_CONFIRMATION_REQUEST_RECEIVED, request);
        PiisConsent consent = null;
        if (this.profileService.isPiisConsentSupported()) {
            AccountReference accountReference = request.getPsuAccount();
            PiisConsentValidationResult validationResult = this.validateAccountReference(accountReference);
            if (validationResult.hasError()) {
                ErrorHolder errorHolder = validationResult.getErrorHolder();
                return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
            }
            consent = validationResult.getConsent();
        }
        if ((response = this.executeRequest(psuIdData = this.getPsuIdData(consent), consent, request, aspspConsentData = this.getAspspConsentData(consent))).hasError()) {
            ErrorHolder errorHolder = response.getErrorHolder();
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        return ResponseObject.builder().body(response).build();
    }

    private PiisConsentValidationResult validateAccountReference(AccountReference accountReference) {
        AccountReferenceSelector selector = accountReference.getUsedAccountReferenceSelector();
        if (selector == null) {
            log.warn("No account identifier in the request {}", (Object)accountReference);
            return new PiisConsentValidationResult(ErrorHolder.builder(MessageErrorCode.FORMAT_ERROR).errorType(ErrorType.PIIS_400).build());
        }
        List response = this.piisConsentService.getPiisConsentListByAccountIdentifier(accountReference.getCurrency(), selector);
        return this.piisConsentValidationService.validatePiisConsentData(response);
    }

    private FundsConfirmationResponse executeRequest(@NotNull PsuIdData psuIdData, @Nullable PiisConsent consent, @NotNull FundsConfirmationRequest request, @NotNull AspspConsentData aspspConsentData) {
        SpiFundsConfirmationRequest spiRequest = this.xs2aToSpiFundsConfirmationRequestMapper.mapToSpiFundsConfirmationRequest(request);
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
        SpiResponse fundsSufficientCheck = this.fundsConfirmationSpi.performFundsSufficientCheck(spiContextData, consent, spiRequest, aspspConsentData);
        if (consent != null) {
            AspspConsentData newAspspConsentData = fundsSufficientCheck.getAspspConsentData();
            this.fundsConfirmationConsentDataService.updateAspspConsentData(newAspspConsentData);
        }
        if (fundsSufficientCheck.hasError()) {
            return new FundsConfirmationResponse(this.spiErrorMapper.mapToErrorHolder(fundsSufficientCheck, ServiceType.PIIS));
        }
        return this.spiToXs2aFundsConfirmationMapper.mapToFundsConfirmationResponse((SpiFundsConfirmationResponse)fundsSufficientCheck.getPayload());
    }

    @NotNull
    private PsuIdData getPsuIdData(@Nullable PiisConsent consent) {
        PsuIdData emptyPsuIdData = new PsuIdData(null, null, null, null);
        if (consent == null) {
            return emptyPsuIdData;
        }
        return Optional.ofNullable(consent.getPsuData()).orElse(emptyPsuIdData);
    }

    @NotNull
    private AspspConsentData getAspspConsentData(@Nullable PiisConsent consent) {
        if (consent == null) {
            return AspspConsentData.emptyConsentData();
        }
        return this.fundsConfirmationConsentDataService.getAspspConsentData(consent.getId());
    }

    @ConstructorProperties(value={"profileService", "fundsConfirmationSpi", "fundsConfirmationConsentDataService", "spiContextDataProvider", "xs2aToSpiFundsConfirmationRequestMapper", "spiToXs2aFundsConfirmationMapper", "piisConsentValidationService", "piisConsentService", "xs2aEventService", "spiErrorMapper"})
    public FundsConfirmationService(AspspProfileServiceWrapper profileService, FundsConfirmationSpi fundsConfirmationSpi, FundsConfirmationConsentDataService fundsConfirmationConsentDataService, SpiContextDataProvider spiContextDataProvider, Xs2aToSpiFundsConfirmationRequestMapper xs2aToSpiFundsConfirmationRequestMapper, SpiToXs2aFundsConfirmationMapper spiToXs2aFundsConfirmationMapper, PiisConsentValidationService piisConsentValidationService, PiisConsentService piisConsentService, Xs2aEventService xs2aEventService, SpiErrorMapper spiErrorMapper) {
        this.profileService = profileService;
        this.fundsConfirmationSpi = fundsConfirmationSpi;
        this.fundsConfirmationConsentDataService = fundsConfirmationConsentDataService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.xs2aToSpiFundsConfirmationRequestMapper = xs2aToSpiFundsConfirmationRequestMapper;
        this.spiToXs2aFundsConfirmationMapper = spiToXs2aFundsConfirmationMapper;
        this.piisConsentValidationService = piisConsentValidationService;
        this.piisConsentService = piisConsentService;
        this.xs2aEventService = xs2aEventService;
        this.spiErrorMapper = spiErrorMapper;
    }
}

