/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.account.SupportedAccountReferenceField;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class AccountReferenceValidationService {
    private static final Logger log = LoggerFactory.getLogger(AccountReferenceValidationService.class);
    private final AspspProfileServiceWrapper profileService;

    public ResponseObject validateAccountReferences(Set<AccountReference> references) {
        List<SupportedAccountReferenceField> supportedFields = this.profileService.getSupportedAccountReferenceFields();
        boolean isInvalidReferenceSet = references.stream().map(ar -> this.isValidAccountReference((AccountReference)ar, supportedFields)).anyMatch(Predicate.isEqual(false));
        return isInvalidReferenceSet ? ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR)).build() : ResponseObject.builder().build();
    }

    private boolean isValidAccountReference(AccountReference reference, List<SupportedAccountReferenceField> supportedFields) {
        Map<SupportedAccountReferenceField, Boolean> validatedFieldsMap = supportedFields.stream().map(fld -> Pair.of((Object)fld, fld.isValid(reference))).filter(p -> ((Optional)p.getValue()).isPresent()).collect(Collectors.toMap(Pair::getKey, p -> (Boolean)((Optional)p.getValue()).get()));
        return this.areValidAllFields(validatedFieldsMap, reference);
    }

    private boolean areValidAllFields(Map<SupportedAccountReferenceField, Boolean> validatedFieldsMap, AccountReference reference) {
        boolean areValid;
        List<SupportedAccountReferenceField> validFields = this.getFilteredFields(validatedFieldsMap, true);
        List<SupportedAccountReferenceField> invalidFields = this.getFilteredFields(validatedFieldsMap, false);
        boolean bl = areValid = !validFields.isEmpty() && invalidFields.isEmpty();
        if (!areValid) {
            invalidFields.forEach(err -> log.warn("Field {} is not valid in reference: {}", (Object)err, (Object)reference));
        }
        return areValid;
    }

    private List<SupportedAccountReferenceField> getFilteredFields(Map<SupportedAccountReferenceField, Boolean> validatedFieldsMap, boolean isValidFilter) {
        return validatedFieldsMap.entrySet().stream().filter(etr -> (Boolean)etr.getValue() == isValidFilter).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"profileService"})
    public AccountReferenceValidationService(AspspProfileServiceWrapper profileService) {
        this.profileService = profileService;
    }
}

