/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ErrorHolder {
    private final List<String> messages;
    private final MessageErrorCode errorCode;
    private final ErrorType errorType;

    private ErrorHolder(ErrorHolderBuilder builder) {
        this.messages = builder.messages;
        this.errorCode = builder.errorCode;
        this.errorType = builder.errorType;
    }

    public String getMessage() {
        if (CollectionUtils.isEmpty(this.messages)) {
            return "";
        }
        return String.join((CharSequence)", ", this.messages);
    }

    public MessageErrorCode getErrorCode() {
        return this.errorCode;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public static ErrorHolderBuilder builder(MessageErrorCode errorCode) {
        return new ErrorHolderBuilder(errorCode);
    }

    public static class ErrorHolderBuilder {
        private List<String> messages;
        private MessageErrorCode errorCode;
        private ErrorType errorType;

        private ErrorHolderBuilder(MessageErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        public ErrorHolderBuilder messages(List<String> messages) {
            this.messages = messages;
            return this;
        }

        public ErrorHolderBuilder errorType(ErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        public ErrorHolder build() {
            return new ErrorHolder(this);
        }
    }
}

