/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.query.account;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.query.AbstractQueryParameterValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.query.account.TransactionListQueryParamsValidator;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DateToQueryParameterParamsValidatorImpl
extends AbstractQueryParameterValidatorImpl
implements TransactionListQueryParamsValidator {
    private static final String DATE_FROM_PARAMETER_NAME = "dateFrom";
    private static final String DATE_TO_PARAMETER_NAME = "dateTo";

    public DateToQueryParameterParamsValidatorImpl(ErrorBuildingService errorBuildingService) {
        super(errorBuildingService);
    }

    @Override
    protected String getQueryParameterName() {
        return DATE_TO_PARAMETER_NAME;
    }

    @Override
    public MessageError validate(Map<String, List<String>> queryParameterMap, MessageError messageError) {
        String dateTo = this.getQueryParameterValue(queryParameterMap, this.getQueryParameterName());
        if (dateTo != null && !this.isDateParamValid(dateTo)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_INVALID_FIELD, (Object[])new Object[]{this.getQueryParameterName()}));
            return messageError;
        }
        String dateFrom = this.getQueryParameterValue(queryParameterMap, DATE_FROM_PARAMETER_NAME);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{dateTo, dateFrom}) && this.isDateParamValid(dateFrom) && LocalDate.parse(dateTo).isBefore(LocalDate.parse(dateFrom))) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_DATE_PERIOD_INVALID, (Object[])new Object[]{DATE_TO_PARAMETER_NAME, DATE_FROM_PARAMETER_NAME}));
        }
        return messageError;
    }
}

