/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.query.account;

import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.query.AbstractQueryParameterValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.query.account.TransactionListQueryParamsValidator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class BookingStatusQueryParameterParamsValidatorImpl
extends AbstractQueryParameterValidatorImpl
implements TransactionListQueryParamsValidator {
    private static final String BOOKING_STATUS_PARAMETER_NAME = "bookingStatus";

    public BookingStatusQueryParameterParamsValidatorImpl(ErrorBuildingService errorBuildingService) {
        super(errorBuildingService);
    }

    @Override
    protected String getQueryParameterName() {
        return BOOKING_STATUS_PARAMETER_NAME;
    }

    @Override
    public MessageError validate(Map<String, List<String>> queryParameterMap, MessageError messageError) {
        ValidationResult presenceValidationResult = this.validateMandatoryParameterPresence(queryParameterMap);
        if (presenceValidationResult.isNotValid()) {
            this.errorBuildingService.enrichMessageError(messageError, presenceValidationResult.getMessageError());
            return messageError;
        }
        String bookingStatusValue = this.getQueryParameterValue(queryParameterMap);
        Optional bookingStatusOptional = BookingStatus.getByValue((String)bookingStatusValue);
        if (bookingStatusOptional.isEmpty()) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_INVALID_PARAMETER_VALUE, (Object[])new Object[]{this.getQueryParameterName()}));
        }
        return messageError;
    }
}

