/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment.handler.type;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.Xs2aAmount;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.AmountValidator;
import de.adorsys.psd2.xs2a.web.validator.body.FieldLengthValidator;
import de.adorsys.psd2.xs2a.web.validator.body.IbanValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.config.PaymentValidationConfig;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.service.CustomPaymentValidationService;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.type.PaymentTypeValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.mapper.PaymentMapper;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SinglePaymentTypeValidatorImpl
extends AbstractBodyValidatorImpl
implements PaymentTypeValidator {
    protected PaymentMapper paymentMapper;
    private final AmountValidator amountValidator;
    private final IbanValidator ibanValidator;
    private final CustomPaymentValidationService customPaymentValidationService;
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    @Autowired
    public SinglePaymentTypeValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper, PaymentMapper paymentMapper, AmountValidator amountValidator, IbanValidator ibanValidator, CustomPaymentValidationService customPaymentValidationService, FieldLengthValidator fieldLengthValidator, AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        super(errorBuildingService, xs2aObjectMapper, fieldLengthValidator);
        this.paymentMapper = paymentMapper;
        this.amountValidator = amountValidator;
        this.ibanValidator = ibanValidator;
        this.customPaymentValidationService = customPaymentValidationService;
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.SINGLE;
    }

    @Override
    public MessageError validate(Object body, MessageError messageError, PaymentValidationConfig validationConfig) {
        try {
            this.doSingleValidation(this.paymentMapper.mapToSinglePayment(body), messageError, validationConfig);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("Unrecognized field")) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_EXTRA_FIELD, (Object[])new Object[]{this.extractErrorField(e.getMessage())}));
            }
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR));
        }
        return messageError;
    }

    void doSingleValidation(SinglePayment singlePayment, MessageError messageError, PaymentValidationConfig validationConfig) {
        this.checkFieldForMaxLength(singlePayment.getEndToEndIdentification(), "endToEndIdentification", validationConfig.getEndToEndIdentification(), messageError);
        if (singlePayment.getDebtorAccount() != null) {
            this.validateAccount(singlePayment.getDebtorAccount(), messageError, validationConfig);
        } else if (!this.aspspProfileServiceWrapper.isDebtorAccountOptionalInInitialRequest()) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"debtorAccount"}));
        }
        if (singlePayment.getInstructedAmount() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"instructedAmount"}));
        } else {
            this.validateInstructedAmount(singlePayment.getInstructedAmount(), messageError);
        }
        if (singlePayment.getCreditorAccount() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"creditorAccount"}));
        } else {
            this.validateAccount(singlePayment.getCreditorAccount(), messageError, validationConfig);
        }
        this.checkFieldForMaxLength(singlePayment.getCreditorName(), "creditorName", validationConfig.getCreditorName(), messageError);
        if (singlePayment.getCreditorAddress() != null) {
            this.validateAddress(singlePayment.getCreditorAddress(), messageError, validationConfig);
        }
        if (this.isDateInThePast(singlePayment.getRequestedExecutionDate())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.EXECUTION_DATE_INVALID_IN_THE_PAST));
        }
        this.checkFieldForMaxLength(singlePayment.getCreditorId(), "creditorId", validationConfig.getCreditorId(), messageError);
        this.checkFieldForMaxLength(singlePayment.getUltimateDebtor(), "ultimateDebtor", validationConfig.getUltimateDebtor(), messageError);
        this.checkFieldForMaxLength(singlePayment.getUltimateCreditor(), "ultimateCreditor", validationConfig.getUltimateDebtor(), messageError);
        this.checkFieldForMaxLength(singlePayment.getInstructionIdentification(), "instructionIdentification", validationConfig.getInstructionIdentification(), messageError);
        this.checkFieldForMaxLength(singlePayment.getDebtorName(), "debtorName", validationConfig.getDebtorName(), messageError);
        this.checkFieldForMaxLength(singlePayment.getRemittanceInformationStructured(), "remittanceInformationStructured", validationConfig.getRemittanceInformationStructured(), messageError);
        this.validateRemittanceInformationStructuredArray(singlePayment.getRemittanceInformationStructuredArray(), messageError, validationConfig);
        this.customPaymentValidationService.performCustomSingleValidation(singlePayment, messageError, validationConfig);
    }

    void validateAddress(Xs2aAddress address, MessageError messageError, PaymentValidationConfig validationConfig) {
        this.checkFieldForMaxLength(address.getStreetName(), "streetName", validationConfig.getStreetName(), messageError);
        this.checkFieldForMaxLength(address.getBuildingNumber(), "buildingNumber", validationConfig.getBuildingNumber(), messageError);
        this.checkFieldForMaxLength(address.getTownName(), "townName", validationConfig.getTownName(), messageError);
        this.checkFieldForMaxLength(address.getPostCode(), "postCode", validationConfig.getPostCode(), messageError);
        if (address.getCountry() == null || StringUtils.isBlank((CharSequence)address.getCountry().getCode())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_VALUE_REQUIRED, (Object[])new Object[]{"address.country"}));
        } else if (!Arrays.asList(Locale.getISOCountries()).contains(address.getCountry().getCode())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_ADDRESS_COUNTRY_INCORRECT));
        }
    }

    private void validateInstructedAmount(Xs2aAmount instructedAmount, MessageError messageError) {
        if (instructedAmount.getCurrency() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_VALUE, (Object[])new Object[]{"currency"}));
        }
        if (instructedAmount.getAmount() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"amount"}));
        } else {
            this.amountValidator.validateAmount(instructedAmount.getAmount(), messageError);
        }
    }

    void validateAccount(AccountReference accountReference, MessageError messageError, PaymentValidationConfig validationConfig) {
        this.ibanValidator.validate(accountReference.getIban(), messageError);
        if (StringUtils.isNotBlank((CharSequence)accountReference.getBban()) && !this.isValidBban(accountReference.getBban())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_INVALID_FIELD, (Object[])new Object[]{"BBAN"}));
        }
        this.checkFieldForMaxLength(accountReference.getPan(), "PAN", validationConfig.getPan(), messageError);
        this.checkFieldForMaxLength(accountReference.getMaskedPan(), "Masked PAN", validationConfig.getMaskedPan(), messageError);
        this.checkFieldForMaxLength(accountReference.getMsisdn(), "MSISDN", validationConfig.getMsisdn(), messageError);
    }

    private boolean isValidBban(String bban) {
        return this.normalizeString(bban).length() >= 11 && this.normalizeString(bban).length() <= 28;
    }

    private String normalizeString(String string) {
        return string.replaceAll("[^a-zA-Z0-9]", "");
    }

    private void validateRemittanceInformationStructuredArray(List<String> remittanceList, MessageError messageError, PaymentValidationConfig validationConfig) {
        if (CollectionUtils.isNotEmpty(remittanceList)) {
            remittanceList.forEach(remittance -> this.checkFieldForMaxLength((String)remittance, "remittanceInformationStructured", validationConfig.getRemittanceInformationStructured(), messageError));
        }
    }

    boolean isDateInThePast(LocalDate dateToCheck) {
        return Optional.ofNullable(dateToCheck).map(date -> date.isBefore(LocalDate.now())).orElse(false);
    }
}

