/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import de.adorsys.psd2.xs2a.web.link.holder.LinkParameters;

public class CreateAisAuthorisationLinks
extends AbstractLinks {
    public CreateAisAuthorisationLinks(LinkParameters linkParameters, CreateConsentAuthorizationResponse response, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, ScaRedirectFlow scaRedirectFlow) {
        super(linkParameters.getHttpUrl());
        String consentId = response.getConsentId();
        String authorisationId = response.getAuthorisationId();
        this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
        ScaApproach initiationScaApproach = scaApproachResolver.getScaApproach(authorisationId);
        if (initiationScaApproach == ScaApproach.REDIRECT) {
            String redirectId = redirectIdService.generateRedirectId(authorisationId);
            String consentOauthLink = scaRedirectFlow == ScaRedirectFlow.OAUTH ? redirectLinkBuilder.buildConsentScaOauthRedirectLink(consentId, redirectId, response.getInternalRequestId()) : redirectLinkBuilder.buildConsentScaRedirectLink(consentId, redirectId, response.getInternalRequestId(), linkParameters.getInstanceId(), ConsentType.AIS);
            this.setScaRedirect(new HrefType(consentOauthLink));
            if (linkParameters.isAuthorisationConfirmationRequestMandated()) {
                this.setConfirmation(this.buildPath(redirectLinkBuilder.buildConfirmationLink(consentId, redirectId, ConsentType.AIS), new Object[0]));
            }
        } else if (initiationScaApproach == ScaApproach.EMBEDDED) {
            this.setUpdatePsuAuthentication(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
        }
    }
}

