/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.Links;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

class AbstractLinks
extends Links {
    private final String httpUrl;

    AbstractLinks(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    HrefType buildPath(String path, Object ... params) {
        UriComponentsBuilder uriComponentsBuilder = StringUtils.startsWith((CharSequence)this.httpUrl, (CharSequence)"/") ? UriComponentsBuilder.fromPath((String)this.httpUrl) : UriComponentsBuilder.fromHttpUrl((String)this.httpUrl);
        return new HrefType(uriComponentsBuilder.path(path).buildAndExpand(params).toUriString());
    }

    protected boolean isScaStatusMethodSelected(AuthenticationObject chosenScaMethod, ScaStatus scaStatus) {
        return chosenScaMethod != null && scaStatus == ScaStatus.SCAMETHODSELECTED;
    }

    protected boolean isScaStatusMethodAuthenticated(ScaStatus scaStatus) {
        return scaStatus == ScaStatus.PSUAUTHENTICATED;
    }

    protected boolean isScaStatusMethodIdentified(ScaStatus scaStatus) {
        return scaStatus == ScaStatus.PSUIDENTIFIED;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLinks)) {
            return false;
        }
        AbstractLinks other = (AbstractLinks)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$httpUrl = this.httpUrl;
        String other$httpUrl = other.httpUrl;
        return !(this$httpUrl == null ? other$httpUrl != null : !this$httpUrl.equals(other$httpUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractLinks;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $httpUrl = this.httpUrl;
        result = result * 59 + ($httpUrl == null ? 43 : $httpUrl.hashCode());
        return result;
    }
}

