/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.profile;

import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.domain.MulticurrencyAccountLevel;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.profile.NotificationSupportedMode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.PiisConsentSupported;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.core.profile.StartAuthorisationMode;
import de.adorsys.psd2.xs2a.core.profile.TppUriCompliance;
import de.adorsys.psd2.xs2a.domain.account.SupportedAccountReferenceField;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AspspProfileServiceWrapper {
    private final AspspProfileService aspspProfileService;
    private final RequestProviderService requestProviderService;

    public Map<PaymentType, Set<String>> getSupportedPaymentTypeAndProductMatrix() {
        return this.readAspspSettings().getPis().getSupportedPaymentTypeAndProductMatrix();
    }

    public List<ScaApproach> getScaApproaches() {
        return this.aspspProfileService.getScaApproaches(this.requestProviderService.getInstanceId());
    }

    public boolean isTppSignatureRequired() {
        return this.readAspspSettings().getCommon().isTppSignatureRequired();
    }

    public String getPisRedirectUrlToAspsp() {
        return this.readAspspSettings().getPis().getRedirectLinkToOnlineBanking().getPisRedirectUrlToAspsp();
    }

    public String getAisRedirectUrlToAspsp() {
        return this.readAspspSettings().getAis().getRedirectLinkToOnlineBanking().getAisRedirectUrlToAspsp();
    }

    public String getPiisRedirectUrlToAspsp() {
        return this.readAspspSettings().getPiis().getRedirectLinkToOnlineBanking().getPiisRedirectUrlToAspsp();
    }

    public List<SupportedAccountReferenceField> getSupportedAccountReferenceFields() {
        List supportedAccountReferenceFields = this.readAspspSettings().getCommon().getSupportedAccountReferenceFields();
        return supportedAccountReferenceFields.stream().map(reference -> SupportedAccountReferenceField.valueOf(reference.name())).collect(Collectors.toList());
    }

    public int getMaxConsentValidityDays() {
        return this.readAspspSettings().getAis().getConsentTypes().getMaxConsentValidityDays();
    }

    public Boolean isGlobalConsentSupported() {
        return this.readAspspSettings().getAis().getConsentTypes().isGlobalConsentSupported();
    }

    public boolean isBankOfferedConsentSupported() {
        return this.readAspspSettings().getAis().getConsentTypes().isBankOfferedConsentSupported();
    }

    public boolean isTransactionsWithoutBalancesSupported() {
        return this.readAspspSettings().getAis().getTransactionParameters().isTransactionsWithoutBalancesSupported();
    }

    public boolean isSigningBasketSupported() {
        return this.readAspspSettings().getSb().isSigningBasketSupported();
    }

    public boolean isPaymentCancellationAuthorisationMandated() {
        return this.readAspspSettings().getPis().isPaymentCancellationAuthorisationMandated();
    }

    public PiisConsentSupported getPiisConsentSupported() {
        return this.readAspspSettings().getPiis().getPiisConsentSupported();
    }

    public long getRedirectUrlExpirationTimeMs() {
        return this.readAspspSettings().getCommon().getRedirectUrlExpirationTimeMs();
    }

    public long getAuthorisationExpirationTimeMs() {
        return this.readAspspSettings().getCommon().getAuthorisationExpirationTimeMs();
    }

    public String getPisPaymentCancellationRedirectUrlToAspsp() {
        return this.readAspspSettings().getPis().getRedirectLinkToOnlineBanking().getPisPaymentCancellationRedirectUrlToAspsp();
    }

    public boolean isAvailableAccountsConsentSupported() {
        return this.readAspspSettings().getAis().getConsentTypes().isAvailableAccountsConsentSupported();
    }

    public boolean isScaByOneTimeAvailableAccountsConsentRequired() {
        return this.readAspspSettings().getAis().getScaRequirementsForOneTimeConsents().isScaByOneTimeAvailableAccountsConsentRequired();
    }

    public boolean isScaByOneTimeGlobalConsentRequired() {
        return this.readAspspSettings().getAis().getScaRequirementsForOneTimeConsents().isScaByOneTimeGlobalConsentRequired();
    }

    public boolean isPsuInInitialRequestMandated() {
        return this.readAspspSettings().getCommon().isPsuInInitialRequestMandated();
    }

    public boolean isForceXs2aBaseLinksUrl() {
        return this.readAspspSettings().getCommon().isForceXs2aBaseLinksUrl();
    }

    public String getXs2aBaseLinksUrl() {
        return this.readAspspSettings().getCommon().getXs2aBaseLinksUrl();
    }

    public boolean isAisPisSessionsSupported() {
        return this.readAspspSettings().getCommon().isAisPisSessionsSupported();
    }

    public boolean isDeltaListSupported() {
        return this.readAspspSettings().getAis().getDeltaReportSettings().isDeltaListSupported();
    }

    public boolean isEntryReferenceFromSupported() {
        return this.readAspspSettings().getAis().getDeltaReportSettings().isEntryReferenceFromSupported();
    }

    public List<BookingStatus> getAvailableBookingStatuses() {
        return this.readAspspSettings().getAis().getTransactionParameters().getAvailableBookingStatuses();
    }

    public StartAuthorisationMode getStartAuthorisationMode() {
        return this.readAspspSettings().getCommon().getStartAuthorisationMode();
    }

    public ScaRedirectFlow getScaRedirectFlow() {
        return this.readAspspSettings().getCommon().getScaRedirectFlow();
    }

    public String getOauthConfigurationUrl() {
        return this.readAspspSettings().getCommon().getOauthConfigurationUrl();
    }

    public int getAccountAccessFrequencyPerDay() {
        return this.readAspspSettings().getAis().getConsentTypes().getAccountAccessFrequencyPerDay();
    }

    public List<String> getSupportedTransactionApplicationTypes() {
        return this.readAspspSettings().getAis().getTransactionParameters().getSupportedTransactionApplicationTypes();
    }

    public boolean isAccountOwnerInformationSupported() {
        return this.readAspspSettings().getAis().getConsentTypes().isAccountOwnerInformationSupported();
    }

    public boolean isTrustedBeneficiariesSupported() {
        return this.readAspspSettings().getAis().getConsentTypes().isTrustedBeneficiariesSupported();
    }

    private AspspSettings readAspspSettings() {
        return this.aspspProfileService.getAspspSettings(this.requestProviderService.getInstanceId());
    }

    public String getSupportedPaymentCountryValidation() {
        return this.readAspspSettings().getPis().getCountryValidationSupported();
    }

    public MulticurrencyAccountLevel getMulticurrencyAccountLevel() {
        return this.readAspspSettings().getCommon().getMulticurrencyAccountLevelSupported();
    }

    public List<String> getSupportedTransactionStatusFormats() {
        return this.readAspspSettings().getPis().getSupportedTransactionStatusFormats();
    }

    public boolean isCheckTppRolesFromCertificateSupported() {
        return this.readAspspSettings().getCommon().isCheckTppRolesFromCertificateSupported();
    }

    public List<NotificationSupportedMode> getNotificationSupportedModes() {
        return this.readAspspSettings().getCommon().getAspspNotificationsSupported();
    }

    public boolean isAuthorisationConfirmationRequestMandated() {
        return this.readAspspSettings().getCommon().isAuthorisationConfirmationRequestMandated();
    }

    public boolean isAuthorisationConfirmationCheckByXs2a() {
        return this.readAspspSettings().getCommon().isAuthorisationConfirmationCheckByXs2a();
    }

    public boolean isCheckUriComplianceToDomainSupported() {
        return this.readAspspSettings().getCommon().isCheckUriComplianceToDomainSupported();
    }

    public TppUriCompliance getTppUriComplianceResponse() {
        return this.readAspspSettings().getCommon().getTppUriComplianceResponse();
    }

    public boolean isPsuInInitialRequestIgnored() {
        return this.readAspspSettings().getCommon().isPsuInInitialRequestIgnored();
    }

    public boolean isIbanValidationDisabled() {
        return this.readAspspSettings().getCommon().isIbanValidationDisabled();
    }

    public boolean isDebtorAccountOptionalInInitialRequest() {
        return this.readAspspSettings().getPis().isDebtorAccountOptionalInInitialRequest();
    }

    @ConstructorProperties(value={"aspspProfileService", "requestProviderService"})
    public AspspProfileServiceWrapper(AspspProfileService aspspProfileService, RequestProviderService requestProviderService) {
        this.aspspProfileService = aspspProfileService;
        this.requestProviderService = requestProviderService;
    }
}

