/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.cancel;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentCancellationRequest;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.payment.cancel.CancelPaymentService;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Optional;

public abstract class AbstractCancelPaymentService
implements CancelPaymentService {
    private final de.adorsys.psd2.xs2a.service.payment.CancelPaymentService cancelPaymentService;

    @Override
    public ResponseObject<CancelPaymentResponse> cancelPayment(CommonPaymentData commonPaymentData, PisPaymentCancellationRequest paymentCancellationRequest) {
        Optional<SpiPayment> spiPaymentOptional = this.createSpiPayment(commonPaymentData);
        if (spiPaymentOptional.isEmpty()) {
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        return this.cancelPaymentService.initiatePaymentCancellation(spiPaymentOptional.get(), paymentCancellationRequest.getEncryptedPaymentId(), paymentCancellationRequest.getTppExplicitAuthorisationPreferred(), paymentCancellationRequest.getTppRedirectUri());
    }

    protected abstract Optional<SpiPayment> createSpiPayment(CommonPaymentData var1);

    @ConstructorProperties(value={"cancelPaymentService"})
    public AbstractCancelPaymentService(de.adorsys.psd2.xs2a.service.payment.CancelPaymentService cancelPaymentService) {
        this.cancelPaymentService = cancelPaymentService;
    }
}

