/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.pis;

import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.exception.model.error500.Error500NGPIS;
import de.adorsys.psd2.xs2a.exception.model.error500.TppMessage500PIS;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class PIS500ErrorMapper
extends Psd2ErrorMapper<MessageError, Error500NGPIS> {
    @Override
    public Function<MessageError, Error500NGPIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    private Error500NGPIS mapToPsd2Error(MessageError messageError) {
        return ((Error500NGPIS.Error500NGPISBuilder)Error500NGPIS.builder().tppMessages(this.mapToTppMessage500PIS(messageError.getTppMessages()))).build();
    }

    private List<TppMessage500PIS> mapToTppMessage500PIS(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> ((TppMessage500PIS.TppMessage500PISBuilder)((TppMessage500PIS.TppMessage500PISBuilder)((TppMessage500PIS.TppMessage500PISBuilder)((TppMessage500PIS.TppMessage500PISBuilder)TppMessage500PIS.builder().category(TppMessageCategory.fromValue((String)m.getCategory().name()))).code(m.getMessageErrorCode().getName())).path(m.getPath())).text(this.getErrorText((TppMessageInformation)m))).build()).collect(Collectors.toList());
    }
}

