/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.TrustedBeneficiary;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTrustedBeneficiaries;
import de.adorsys.psd2.xs2a.service.mapper.TrustedBeneficiariesModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrustedBeneficiariesModelMapperImpl
implements TrustedBeneficiariesModelMapper {
    @Autowired
    private Xs2aAddressMapper xs2aAddressMapper;

    @Override
    public TrustedBeneficiary mapToTrustedBeneficiaries(Xs2aTrustedBeneficiaries trustedBeneficiaries) {
        if (trustedBeneficiaries == null) {
            return null;
        }
        TrustedBeneficiary trustedBeneficiary = new TrustedBeneficiary();
        trustedBeneficiary.setTrustedBeneficiaryId(trustedBeneficiaries.getTrustedBeneficiaryId());
        trustedBeneficiary.setCreditorAgent(trustedBeneficiaries.getCreditorAgent());
        trustedBeneficiary.setCreditorName(trustedBeneficiaries.getCreditorName());
        trustedBeneficiary.setCreditorAlias(trustedBeneficiaries.getCreditorAlias());
        trustedBeneficiary.setCreditorId(trustedBeneficiaries.getCreditorId());
        trustedBeneficiary.setCreditorAddress(this.xs2aAddressMapper.mapToAddress(trustedBeneficiaries.getCreditorAddress()));
        trustedBeneficiary.setCreditorAccount(this.mapToAccountReference(trustedBeneficiaries.getCreditorAccount()));
        trustedBeneficiary.setDebtorAccount(this.mapToAccountReference(trustedBeneficiaries.getDebtorAccount()));
        return trustedBeneficiary;
    }

    @Override
    public AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference value) {
        if (value == null) {
            return null;
        }
        AccountReference accountReference = new AccountReference();
        accountReference.setIban(value.getIban());
        accountReference.setBban(value.getBban());
        accountReference.setPan(value.getPan());
        accountReference.setMaskedPan(value.getMaskedPan());
        accountReference.setMsisdn(value.getMsisdn());
        accountReference.setCashAccountType(value.getCashAccountType());
        accountReference.setCurrency(this.mapToCurrency(value.getCurrency()));
        accountReference.setOther(this.mapToOtherType(value.getOther()));
        return accountReference;
    }
}

