/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.OtherType;
import de.adorsys.psd2.model.TrustedBeneficiariesList;
import de.adorsys.psd2.model.TrustedBeneficiary;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTrustedBeneficiaries;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTrustedBeneficiariesList;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import java.util.Currency;
import java.util.List;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring", uses={Xs2aAddressMapper.class})
public interface TrustedBeneficiariesModelMapper {
    default public TrustedBeneficiariesList mapToTrustedBeneficiariesList(Xs2aTrustedBeneficiariesList xs2ATrustedBeneficiariesList) {
        List<Xs2aTrustedBeneficiaries> trustedBeneficiaries = xs2ATrustedBeneficiariesList.getTrustedBeneficiaries();
        List beneficiaries = trustedBeneficiaries.stream().map(this::mapToTrustedBeneficiaries).collect(Collectors.toList());
        TrustedBeneficiariesList result = new TrustedBeneficiariesList();
        result.addAll(beneficiaries);
        return result;
    }

    @Mappings(value={@Mapping(target="creditorAccount", expression="java(mapToAccountReference(trustedBeneficiaries.getCreditorAccount()))"), @Mapping(target="debtorAccount", expression="java(mapToAccountReference(trustedBeneficiaries.getDebtorAccount()))")})
    public TrustedBeneficiary mapToTrustedBeneficiaries(Xs2aTrustedBeneficiaries var1);

    @Mappings(value={@Mapping(target="currency", expression="java(mapToCurrency(value.getCurrency()))"), @Mapping(target="other", expression="java(mapToOtherType(value.getOther()))")})
    public AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference var1);

    default public OtherType mapToOtherType(String other) {
        return other == null ? null : new OtherType().identification(other);
    }

    default public String mapToCurrency(Currency value) {
        return value == null ? null : value.getCurrencyCode();
    }
}

