/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AccountReport;
import de.adorsys.psd2.model.AdditionalInformationStructured;
import de.adorsys.psd2.model.EntryDetailsElement;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.MonthsOfExecution;
import de.adorsys.psd2.model.RemittanceInformationUnstructuredArray;
import de.adorsys.psd2.model.StandingOrderDetails;
import de.adorsys.psd2.model.TransactionsResponse200Json;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.domain.EntryDetails;
import de.adorsys.psd2.xs2a.domain.TransactionInfo;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAdditionalInformationStructured;
import de.adorsys.psd2.xs2a.domain.account.Xs2aStandingOrderDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.ReportExchangeMapper;
import de.adorsys.psd2.xs2a.service.mapper.TransactionModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.BalanceMapper;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionModelMapperImpl
extends TransactionModelMapper {
    @Autowired
    private AmountModelMapper amountModelMapper;
    @Autowired
    private PurposeCodeMapper purposeCodeMapper;
    @Autowired
    private ReportExchangeMapper reportExchangeMapper;
    @Autowired
    private BalanceMapper balanceMapper;

    @Override
    public AccountReport mapToAccountReport(Xs2aAccountReport accountReport) {
        if (accountReport == null) {
            return null;
        }
        AccountReport accountReport1 = new AccountReport();
        accountReport1.setBooked(this.mapToTransactionList(accountReport.getBooked()));
        accountReport1.setPending(this.mapToTransactionList(accountReport.getPending()));
        accountReport1.setInformation(this.mapToTransactionList(accountReport.getInformation()));
        accountReport1.setLinks(this.hrefLinkMapper.mapToLinksMap(accountReport.getLinks()));
        return accountReport1;
    }

    @Override
    public TransactionsResponse200Json mapToTransactionsResponse200Json(Xs2aTransactionsReport transactionsReport) {
        if (transactionsReport == null) {
            return null;
        }
        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();
        transactionsResponse200Json.setTransactions(this.mapToAccountReport(transactionsReport.getAccountReport()));
        transactionsResponse200Json.setBalances(this.balanceMapper.mapToBalanceList(transactionsReport.getBalances()));
        transactionsResponse200Json.setLinks(this.hrefLinkMapper.mapToLinksMap(transactionsReport.getLinks()));
        transactionsResponse200Json.setAccount(this.mapToAccountReference(transactionsReport.getAccountReference()));
        return transactionsResponse200Json;
    }

    @Override
    public de.adorsys.psd2.model.Transactions mapToTransactions(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        de.adorsys.psd2.model.Transactions transactions1 = new de.adorsys.psd2.model.Transactions();
        transactions1.setBankTransactionCode(this.transactionsBankTransactionCodeCodeCode(transactions));
        transactions1.setTransactionAmount(this.amountModelMapper.mapToAmount(transactions.getAmount()));
        transactions1.setCreditorName(this.transactionsTransactionInfoCreditorName(transactions));
        transactions1.setCreditorAgent(this.transactionsTransactionInfoCreditorAgent(transactions));
        transactions1.setUltimateCreditor(this.transactionsTransactionInfoUltimateCreditor(transactions));
        transactions1.setDebtorName(this.transactionsTransactionInfoDebtorName(transactions));
        transactions1.setDebtorAgent(this.transactionsTransactionInfoDebtorAgent(transactions));
        transactions1.setUltimateDebtor(this.transactionsTransactionInfoUltimateDebtor(transactions));
        transactions1.setRemittanceInformationUnstructured(this.transactionsTransactionInfoRemittanceInformationUnstructured(transactions));
        List<String> remittanceInformationUnstructuredArray = this.transactionsTransactionInfoRemittanceInformationUnstructuredArray(transactions);
        transactions1.setRemittanceInformationUnstructuredArray(this.stringListToRemittanceInformationUnstructuredArray(remittanceInformationUnstructuredArray));
        transactions1.setRemittanceInformationStructured(this.transactionsTransactionInfoRemittanceInformationStructured(transactions));
        transactions1.setPurposeCode(this.purposeCodeMapper.mapToPurposeCode(this.transactionsTransactionInfoPurposeCode(transactions)));
        transactions1.setTransactionId(transactions.getTransactionId());
        transactions1.setEntryReference(transactions.getEntryReference());
        transactions1.setEndToEndId(transactions.getEndToEndId());
        transactions1.setBatchIndicator(transactions.getBatchIndicator());
        transactions1.setBatchNumberOfTransactions(transactions.getBatchNumberOfTransactions());
        transactions1.setMandateId(transactions.getMandateId());
        transactions1.setCheckId(transactions.getCheckId());
        transactions1.setCreditorId(transactions.getCreditorId());
        transactions1.setBookingDate(transactions.getBookingDate());
        transactions1.setValueDate(transactions.getValueDate());
        transactions1.setEntryDetails(this.entryDetailsListToEntryDetails(transactions.getEntryDetails()));
        transactions1.setAdditionalInformation(transactions.getAdditionalInformation());
        transactions1.setAdditionalInformationStructured(this.xs2aAdditionalInformationStructuredToAdditionalInformationStructured(transactions.getAdditionalInformationStructured()));
        transactions1.setProprietaryBankTransactionCode(transactions.getProprietaryBankTransactionCode());
        transactions1.setBalanceAfterTransaction(this.balanceMapper.mapToBalance(transactions.getBalanceAfterTransaction()));
        transactions1.setCurrencyExchange(this.reportExchangeMapper.mapToReportExchanges(transactions.getExchangeRate()));
        transactions1.setCreditorAccount(this.mapToAccountReference(transactions.getTransactionInfo(), true));
        transactions1.setDebtorAccount(this.mapToAccountReference(transactions.getTransactionInfo(), false));
        transactions1.setRemittanceInformationStructuredArray(this.mapToRemittanceInformationStructuredArray(transactions.getTransactionInfo()));
        return transactions1;
    }

    @Override
    public EntryDetailsElement mapToEntryDetailsElement(EntryDetails entryDetails) {
        if (entryDetails == null) {
            return null;
        }
        EntryDetailsElement entryDetailsElement = new EntryDetailsElement();
        entryDetailsElement.setCreditorName(this.entryDetailsTransactionInfoCreditorName(entryDetails));
        entryDetailsElement.setCreditorAgent(this.entryDetailsTransactionInfoCreditorAgent(entryDetails));
        entryDetailsElement.setUltimateCreditor(this.entryDetailsTransactionInfoUltimateCreditor(entryDetails));
        entryDetailsElement.setDebtorName(this.entryDetailsTransactionInfoDebtorName(entryDetails));
        entryDetailsElement.setDebtorAgent(this.entryDetailsTransactionInfoDebtorAgent(entryDetails));
        entryDetailsElement.setUltimateDebtor(this.entryDetailsTransactionInfoUltimateDebtor(entryDetails));
        entryDetailsElement.setRemittanceInformationUnstructured(this.entryDetailsTransactionInfoRemittanceInformationUnstructured(entryDetails));
        List<String> remittanceInformationUnstructuredArray = this.entryDetailsTransactionInfoRemittanceInformationUnstructuredArray(entryDetails);
        entryDetailsElement.setRemittanceInformationUnstructuredArray(this.stringListToRemittanceInformationUnstructuredArray(remittanceInformationUnstructuredArray));
        entryDetailsElement.setPurposeCode(this.purposeCodeMapper.mapToPurposeCode(this.entryDetailsTransactionInfoPurposeCode(entryDetails)));
        entryDetailsElement.setEndToEndId(entryDetails.getEndToEndId());
        entryDetailsElement.setMandateId(entryDetails.getMandateId());
        entryDetailsElement.setCheckId(entryDetails.getCheckId());
        entryDetailsElement.setCreditorId(entryDetails.getCreditorId());
        entryDetailsElement.setTransactionAmount(this.amountModelMapper.mapToAmount(entryDetails.getTransactionAmount()));
        entryDetailsElement.setCurrencyExchange(this.reportExchangeMapper.mapToReportExchanges(entryDetails.getCurrencyExchange()));
        entryDetailsElement.setCreditorAccount(this.mapToAccountReference(entryDetails.getTransactionInfo(), true));
        entryDetailsElement.setDebtorAccount(this.mapToAccountReference(entryDetails.getTransactionInfo(), false));
        entryDetailsElement.setRemittanceInformationStructured(this.mapToRemittanceInformationStructured(entryDetails.getTransactionInfo()));
        entryDetailsElement.setRemittanceInformationStructuredArray(this.mapToRemittanceInformationStructuredArray(entryDetails.getTransactionInfo()));
        return entryDetailsElement;
    }

    @Override
    public AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference value) {
        if (value == null) {
            return null;
        }
        AccountReference accountReference = new AccountReference();
        accountReference.setIban(value.getIban());
        accountReference.setBban(value.getBban());
        accountReference.setPan(value.getPan());
        accountReference.setMaskedPan(value.getMaskedPan());
        accountReference.setMsisdn(value.getMsisdn());
        accountReference.setCashAccountType(value.getCashAccountType());
        accountReference.setCurrency(this.mapToCurrency(value.getCurrency()));
        accountReference.setOther(this.mapToOtherType(value.getOther()));
        return accountReference;
    }

    private String transactionsBankTransactionCodeCodeCode(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        BankTransactionCode bankTransactionCodeCode = transactions.getBankTransactionCodeCode();
        if (bankTransactionCodeCode == null) {
            return null;
        }
        String code = bankTransactionCodeCode.getCode();
        if (code == null) {
            return null;
        }
        return code;
    }

    private String transactionsTransactionInfoCreditorName(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String creditorName = transactionInfo.getCreditorName();
        if (creditorName == null) {
            return null;
        }
        return creditorName;
    }

    private String transactionsTransactionInfoCreditorAgent(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String creditorAgent = transactionInfo.getCreditorAgent();
        if (creditorAgent == null) {
            return null;
        }
        return creditorAgent;
    }

    private String transactionsTransactionInfoUltimateCreditor(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String ultimateCreditor = transactionInfo.getUltimateCreditor();
        if (ultimateCreditor == null) {
            return null;
        }
        return ultimateCreditor;
    }

    private String transactionsTransactionInfoDebtorName(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String debtorName = transactionInfo.getDebtorName();
        if (debtorName == null) {
            return null;
        }
        return debtorName;
    }

    private String transactionsTransactionInfoDebtorAgent(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String debtorAgent = transactionInfo.getDebtorAgent();
        if (debtorAgent == null) {
            return null;
        }
        return debtorAgent;
    }

    private String transactionsTransactionInfoUltimateDebtor(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String ultimateDebtor = transactionInfo.getUltimateDebtor();
        if (ultimateDebtor == null) {
            return null;
        }
        return ultimateDebtor;
    }

    private String transactionsTransactionInfoRemittanceInformationUnstructured(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String remittanceInformationUnstructured = transactionInfo.getRemittanceInformationUnstructured();
        if (remittanceInformationUnstructured == null) {
            return null;
        }
        return remittanceInformationUnstructured;
    }

    private List<String> transactionsTransactionInfoRemittanceInformationUnstructuredArray(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        List<String> remittanceInformationUnstructuredArray = transactionInfo.getRemittanceInformationUnstructuredArray();
        if (remittanceInformationUnstructuredArray == null) {
            return null;
        }
        return remittanceInformationUnstructuredArray;
    }

    protected RemittanceInformationUnstructuredArray stringListToRemittanceInformationUnstructuredArray(List<String> list) {
        if (list == null) {
            return null;
        }
        RemittanceInformationUnstructuredArray remittanceInformationUnstructuredArray = new RemittanceInformationUnstructuredArray();
        for (String string : list) {
            remittanceInformationUnstructuredArray.add((Object)string);
        }
        return remittanceInformationUnstructuredArray;
    }

    private String transactionsTransactionInfoRemittanceInformationStructured(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String remittanceInformationStructured = transactionInfo.getRemittanceInformationStructured();
        if (remittanceInformationStructured == null) {
            return null;
        }
        return remittanceInformationStructured;
    }

    private PurposeCode transactionsTransactionInfoPurposeCode(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        TransactionInfo transactionInfo = transactions.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        PurposeCode purposeCode = transactionInfo.getPurposeCode();
        if (purposeCode == null) {
            return null;
        }
        return purposeCode;
    }

    protected de.adorsys.psd2.model.EntryDetails entryDetailsListToEntryDetails(List<EntryDetails> list) {
        if (list == null) {
            return null;
        }
        de.adorsys.psd2.model.EntryDetails entryDetails1 = new de.adorsys.psd2.model.EntryDetails();
        for (EntryDetails entryDetails : list) {
            entryDetails1.add((Object)this.mapToEntryDetailsElement(entryDetails));
        }
        return entryDetails1;
    }

    protected FrequencyCode frequencyCodeToFrequencyCode(de.adorsys.psd2.xs2a.core.pis.FrequencyCode frequencyCode) {
        FrequencyCode frequencyCode1;
        if (frequencyCode == null) {
            return null;
        }
        switch (frequencyCode) {
            case DAILY: {
                frequencyCode1 = FrequencyCode.DAILY;
                break;
            }
            case WEEKLY: {
                frequencyCode1 = FrequencyCode.WEEKLY;
                break;
            }
            case EVERYTWOWEEKS: {
                frequencyCode1 = FrequencyCode.EVERYTWOWEEKS;
                break;
            }
            case MONTHLY: {
                frequencyCode1 = FrequencyCode.MONTHLY;
                break;
            }
            case EVERYTWOMONTHS: {
                frequencyCode1 = FrequencyCode.EVERYTWOMONTHS;
                break;
            }
            case QUARTERLY: {
                frequencyCode1 = FrequencyCode.QUARTERLY;
                break;
            }
            case SEMIANNUAL: {
                frequencyCode1 = FrequencyCode.SEMIANNUAL;
                break;
            }
            case ANNUAL: {
                frequencyCode1 = FrequencyCode.ANNUAL;
                break;
            }
            case MONTHLYVARIABLE: {
                frequencyCode1 = FrequencyCode.MONTHLYVARIABLE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + frequencyCode);
            }
        }
        return frequencyCode1;
    }

    protected ExecutionRule pisExecutionRuleToExecutionRule(PisExecutionRule pisExecutionRule) {
        ExecutionRule executionRule;
        if (pisExecutionRule == null) {
            return null;
        }
        switch (pisExecutionRule) {
            case FOLLOWING: {
                executionRule = ExecutionRule.FOLLOWING;
                break;
            }
            case PRECEDING: {
                executionRule = ExecutionRule.PRECEDING;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + pisExecutionRule);
            }
        }
        return executionRule;
    }

    protected MonthsOfExecution stringListToMonthsOfExecution(List<String> list) {
        if (list == null) {
            return null;
        }
        MonthsOfExecution monthsOfExecution = new MonthsOfExecution();
        for (String string : list) {
            monthsOfExecution.add((Object)string);
        }
        return monthsOfExecution;
    }

    protected StandingOrderDetails xs2aStandingOrderDetailsToStandingOrderDetails(Xs2aStandingOrderDetails xs2aStandingOrderDetails) {
        if (xs2aStandingOrderDetails == null) {
            return null;
        }
        StandingOrderDetails standingOrderDetails = new StandingOrderDetails();
        standingOrderDetails.setStartDate(xs2aStandingOrderDetails.getStartDate());
        standingOrderDetails.setFrequency(this.frequencyCodeToFrequencyCode(xs2aStandingOrderDetails.getFrequency()));
        standingOrderDetails.setEndDate(xs2aStandingOrderDetails.getEndDate());
        standingOrderDetails.setExecutionRule(this.pisExecutionRuleToExecutionRule(xs2aStandingOrderDetails.getExecutionRule()));
        standingOrderDetails.setWithinAMonthFlag(xs2aStandingOrderDetails.getWithinAMonthFlag());
        standingOrderDetails.setMonthsOfExecution(this.stringListToMonthsOfExecution(xs2aStandingOrderDetails.getMonthsOfExecution()));
        standingOrderDetails.setMultiplicator(xs2aStandingOrderDetails.getMultiplicator());
        standingOrderDetails.setLimitAmount(this.amountModelMapper.mapToAmount(xs2aStandingOrderDetails.getLimitAmount()));
        standingOrderDetails.setDayOfExecution(this.dayOfExecutionMapper.mapDayOfExecution(xs2aStandingOrderDetails.getDayOfExecution()));
        return standingOrderDetails;
    }

    protected AdditionalInformationStructured xs2aAdditionalInformationStructuredToAdditionalInformationStructured(Xs2aAdditionalInformationStructured xs2aAdditionalInformationStructured) {
        if (xs2aAdditionalInformationStructured == null) {
            return null;
        }
        AdditionalInformationStructured additionalInformationStructured = new AdditionalInformationStructured();
        additionalInformationStructured.setStandingOrderDetails(this.xs2aStandingOrderDetailsToStandingOrderDetails(xs2aAdditionalInformationStructured.getStandingOrderDetails()));
        return additionalInformationStructured;
    }

    private String entryDetailsTransactionInfoCreditorName(EntryDetails entryDetails) {
        if (entryDetails == null) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String creditorName = transactionInfo.getCreditorName();
        if (creditorName == null) {
            return null;
        }
        return creditorName;
    }

    private String entryDetailsTransactionInfoCreditorAgent(EntryDetails entryDetails) {
        if (entryDetails == null) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String creditorAgent = transactionInfo.getCreditorAgent();
        if (creditorAgent == null) {
            return null;
        }
        return creditorAgent;
    }

    private String entryDetailsTransactionInfoUltimateCreditor(EntryDetails entryDetails) {
        if (entryDetails == null) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String ultimateCreditor = transactionInfo.getUltimateCreditor();
        if (ultimateCreditor == null) {
            return null;
        }
        return ultimateCreditor;
    }

    private String entryDetailsTransactionInfoDebtorName(EntryDetails entryDetails) {
        if (entryDetails == null) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String debtorName = transactionInfo.getDebtorName();
        if (debtorName == null) {
            return null;
        }
        return debtorName;
    }

    private String entryDetailsTransactionInfoDebtorAgent(EntryDetails entryDetails) {
        if (entryDetails == null) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String debtorAgent = transactionInfo.getDebtorAgent();
        if (debtorAgent == null) {
            return null;
        }
        return debtorAgent;
    }

    private String entryDetailsTransactionInfoUltimateDebtor(EntryDetails entryDetails) {
        if (entryDetails == null) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String ultimateDebtor = transactionInfo.getUltimateDebtor();
        if (ultimateDebtor == null) {
            return null;
        }
        return ultimateDebtor;
    }

    private String entryDetailsTransactionInfoRemittanceInformationUnstructured(EntryDetails entryDetails) {
        if (entryDetails == null) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        String remittanceInformationUnstructured = transactionInfo.getRemittanceInformationUnstructured();
        if (remittanceInformationUnstructured == null) {
            return null;
        }
        return remittanceInformationUnstructured;
    }

    private List<String> entryDetailsTransactionInfoRemittanceInformationUnstructuredArray(EntryDetails entryDetails) {
        if (entryDetails == null) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        List<String> remittanceInformationUnstructuredArray = transactionInfo.getRemittanceInformationUnstructuredArray();
        if (remittanceInformationUnstructuredArray == null) {
            return null;
        }
        return remittanceInformationUnstructuredArray;
    }

    private PurposeCode entryDetailsTransactionInfoPurposeCode(EntryDetails entryDetails) {
        if (entryDetails == null) {
            return null;
        }
        TransactionInfo transactionInfo = entryDetails.getTransactionInfo();
        if (transactionInfo == null) {
            return null;
        }
        PurposeCode purposeCode = transactionInfo.getPurposeCode();
        if (purposeCode == null) {
            return null;
        }
        return purposeCode;
    }
}

