/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AccountReport;
import de.adorsys.psd2.model.EntryDetailsElement;
import de.adorsys.psd2.model.InlineResponse2001;
import de.adorsys.psd2.model.OtherType;
import de.adorsys.psd2.model.RemittanceInformationStructured;
import de.adorsys.psd2.model.RemittanceInformationStructuredArray;
import de.adorsys.psd2.model.TransactionList;
import de.adorsys.psd2.model.TransactionsResponse200Json;
import de.adorsys.psd2.xs2a.domain.EntryDetails;
import de.adorsys.psd2.xs2a.domain.TransactionInfo;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.ReportExchangeMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.mapper.BalanceMapper;
import de.adorsys.psd2.xs2a.web.mapper.DayOfExecutionMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import java.util.Currency;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", uses={AmountModelMapper.class, PurposeCodeMapper.class, Xs2aAddressMapper.class, AspspProfileServiceWrapper.class, ReportExchangeMapper.class, BalanceMapper.class, DayOfExecutionMapper.class})
public abstract class TransactionModelMapper {
    @Autowired
    protected ReportExchangeMapper reportExchangeMapper;
    @Autowired
    protected HrefLinkMapper hrefLinkMapper;
    @Autowired
    protected BalanceMapper balanceMapper;
    @Autowired
    protected DayOfExecutionMapper dayOfExecutionMapper;

    @Mappings(value={@Mapping(target="_links", ignore=true), @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(accountReport.getLinks()))")})
    public abstract AccountReport mapToAccountReport(Xs2aAccountReport var1);

    @Mappings(value={@Mapping(target="_links", ignore=true), @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(transactionsReport.getLinks()))"), @Mapping(target="transactions", source="accountReport"), @Mapping(target="account", expression="java(mapToAccountReference(transactionsReport.getAccountReference()))")})
    public abstract TransactionsResponse200Json mapToTransactionsResponse200Json(Xs2aTransactionsReport var1);

    public byte[] mapToTransactionsResponseRaw(Xs2aTransactionsReport transactionsReport) {
        return transactionsReport.getAccountReport().getTransactionsRaw();
    }

    @Mappings(value={@Mapping(target="currencyExchange", expression="java(reportExchangeMapper.mapToReportExchanges(transactions.getExchangeRate()))"), @Mapping(target="bankTransactionCode", source="bankTransactionCodeCode.code"), @Mapping(target="transactionAmount", source="amount"), @Mapping(target="additionalInformationStructured.standingOrderDetails.dayOfExecution", expression="java(dayOfExecutionMapper.mapDayOfExecution(xs2aStandingOrderDetails.getDayOfExecution()))"), @Mapping(target="links", ignore=true), @Mapping(target="_links", ignore=true), @Mapping(target="creditorName", source="transactionInfo.creditorName"), @Mapping(target="creditorAccount", expression="java(mapToAccountReference(transactions.getTransactionInfo(), true))"), @Mapping(target="creditorAgent", source="transactionInfo.creditorAgent"), @Mapping(target="ultimateCreditor", source="transactionInfo.ultimateCreditor"), @Mapping(target="debtorName", source="transactionInfo.debtorName"), @Mapping(target="debtorAccount", expression="java(mapToAccountReference(transactions.getTransactionInfo(), false))"), @Mapping(target="debtorAgent", source="transactionInfo.debtorAgent"), @Mapping(target="ultimateDebtor", source="transactionInfo.ultimateDebtor"), @Mapping(target="remittanceInformationUnstructured", source="transactionInfo.remittanceInformationUnstructured"), @Mapping(target="remittanceInformationUnstructuredArray", source="transactionInfo.remittanceInformationUnstructuredArray"), @Mapping(target="remittanceInformationStructured", source="transactionInfo.remittanceInformationStructured"), @Mapping(target="remittanceInformationStructuredArray", expression="java(mapToRemittanceInformationStructuredArray(transactions.getTransactionInfo()))"), @Mapping(target="purposeCode", source="transactionInfo.purposeCode")})
    public abstract de.adorsys.psd2.model.Transactions mapToTransactions(Transactions var1);

    @Mappings(value={@Mapping(target="creditorName", source="transactionInfo.creditorName"), @Mapping(target="creditorAccount", expression="java(mapToAccountReference(entryDetails.getTransactionInfo(), true))"), @Mapping(target="creditorAgent", source="transactionInfo.creditorAgent"), @Mapping(target="ultimateCreditor", source="transactionInfo.ultimateCreditor"), @Mapping(target="debtorName", source="transactionInfo.debtorName"), @Mapping(target="debtorAccount", expression="java(mapToAccountReference(entryDetails.getTransactionInfo(), false))"), @Mapping(target="debtorAgent", source="transactionInfo.debtorAgent"), @Mapping(target="ultimateDebtor", source="transactionInfo.ultimateDebtor"), @Mapping(target="remittanceInformationUnstructured", source="transactionInfo.remittanceInformationUnstructured"), @Mapping(target="remittanceInformationUnstructuredArray", source="transactionInfo.remittanceInformationUnstructuredArray"), @Mapping(target="remittanceInformationStructured", expression="java(mapToRemittanceInformationStructured(entryDetails.getTransactionInfo()))"), @Mapping(target="remittanceInformationStructuredArray", expression="java(mapToRemittanceInformationStructuredArray(entryDetails.getTransactionInfo()))"), @Mapping(target="purposeCode", source="transactionInfo.purposeCode")})
    public abstract EntryDetailsElement mapToEntryDetailsElement(EntryDetails var1);

    public InlineResponse2001 mapToTransactionDetails(Transactions transactions) {
        InlineResponse2001 inlineResponse2001 = new InlineResponse2001();
        inlineResponse2001.setTransactionsDetails(this.mapToTransactions(transactions));
        return inlineResponse2001;
    }

    @Nullable
    protected TransactionList mapToTransactionList(@Nullable List<Transactions> transactions) {
        if (CollectionUtils.isEmpty(transactions)) {
            return null;
        }
        List transactionDetails = transactions.stream().map(this::mapToTransactions).collect(Collectors.toList());
        TransactionList transactionList = new TransactionList();
        transactionList.addAll(transactionDetails);
        return transactionList;
    }

    protected RemittanceInformationStructuredArray mapToRemittanceInformationStructuredArray(TransactionInfo transactionInfo) {
        if (transactionInfo == null || CollectionUtils.isEmpty(transactionInfo.getRemittanceInformationStructuredArray())) {
            return null;
        }
        List remittanceInfoStructuredList = transactionInfo.getRemittanceInformationStructuredArray().stream().map(s -> new RemittanceInformationStructured().reference(s)).collect(Collectors.toList());
        RemittanceInformationStructuredArray remittanceInfoStructuredArray = new RemittanceInformationStructuredArray();
        remittanceInfoStructuredArray.addAll(remittanceInfoStructuredList);
        return remittanceInfoStructuredArray;
    }

    protected RemittanceInformationStructured mapToRemittanceInformationStructured(TransactionInfo transactionInfo) {
        if (transactionInfo == null || transactionInfo.getRemittanceInformationStructured() == null) {
            return null;
        }
        return new RemittanceInformationStructured().reference(transactionInfo.getRemittanceInformationStructured());
    }

    @Mappings(value={@Mapping(target="currency", expression="java(mapToCurrency(value.getCurrency()))"), @Mapping(target="other", expression="java(mapToOtherType(value.getOther()))")})
    public abstract AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference var1);

    protected AccountReference mapToAccountReference(TransactionInfo transactionInfo, boolean isCreditorAccount) {
        if (transactionInfo == null) {
            return null;
        }
        de.adorsys.psd2.xs2a.core.profile.AccountReference value = isCreditorAccount ? transactionInfo.getCreditorAccount() : transactionInfo.getDebtorAccount();
        return this.mapToAccountReference(value);
    }

    protected OtherType mapToOtherType(String other) {
        return other == null ? null : new OtherType().identification(other);
    }

    protected String mapToCurrency(Currency value) {
        return value == null ? null : value.getCurrencyCode();
    }
}

