/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.model.RemittanceInformationStructured;
import de.adorsys.psd2.model.RemittanceInformationStructuredArray;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import de.adorsys.psd2.xs2a.web.mapper.RemittanceMapper;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring", uses={Xs2aAddressMapper.class, RemittanceMapper.class, PurposeCodeMapper.class}, imports={RemittanceInformationStructured.class})
public interface PaymentModelMapper {
    @Mappings(value={@Mapping(target="dayOfExecution", expression="java(mapDayOfExecution(paymentRequest.getDayOfExecution()))"), @Mapping(target="remittanceInformationStructuredArray", expression="java(mapToRemittanceInformationStructuredString(paymentRequest.getRemittanceInformationStructuredArray()))")})
    public PeriodicPayment mapToXs2aPayment(PeriodicPaymentInitiationJson var1);

    public SinglePayment mapToXs2aPayment(PaymentInitiationJson var1);

    public BulkPayment mapToXs2aPayment(BulkPaymentInitiationJson var1);

    public Xs2aAmount mapToXs2aAmount(Amount var1);

    @Mapping(target="other", source="other.identification")
    public de.adorsys.psd2.xs2a.core.profile.AccountReference mapToAccountReference(AccountReference var1);

    @AfterMapping
    default public void mapToXs2aPaymentAfterMapping(BulkPaymentInitiationJson paymentRequest, @MappingTarget BulkPayment bulkPayment) {
        LocalDate requestedExecutionDate = paymentRequest.getRequestedExecutionDate();
        OffsetDateTime requestedExecutionTime = paymentRequest.getRequestedExecutionTime();
        de.adorsys.psd2.xs2a.core.profile.AccountReference debtorAccount = this.mapToAccountReference(paymentRequest.getDebtorAccount());
        bulkPayment.getPayments().forEach(bp -> {
            bp.setRequestedExecutionDate(requestedExecutionDate);
            bp.setRequestedExecutionTime(requestedExecutionTime);
            bp.setDebtorAccount(debtorAccount);
        });
    }

    default public PisDayOfExecution mapDayOfExecution(DayOfExecution dayOfExecution) {
        if (dayOfExecution != null) {
            Optional pisDayOfExecutionOptional = PisDayOfExecution.getByValue((String)dayOfExecution.toString());
            return pisDayOfExecutionOptional.orElse(null);
        }
        return null;
    }

    default public List<String> mapToRemittanceInformationStructuredString(RemittanceInformationStructuredArray value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return value.stream().map(RemittanceInformationStructured::getReference).collect(Collectors.toList());
    }
}

