/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.aspsp.profile.domain.MulticurrencyAccountLevel;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Balance;
import de.adorsys.psd2.model.BalanceList;
import de.adorsys.psd2.model.BalanceType;
import de.adorsys.psd2.model.CardAccountDetails;
import de.adorsys.psd2.model.CardAccountList;
import de.adorsys.psd2.model.CardAccountReport;
import de.adorsys.psd2.model.CardAccountsTransactionsResponse200;
import de.adorsys.psd2.model.CardTransaction;
import de.adorsys.psd2.model.CardTransactionList;
import de.adorsys.psd2.model.InlineResponse2002;
import de.adorsys.psd2.model.OtherType;
import de.adorsys.psd2.model.ReadCardAccountBalanceResponse200;
import de.adorsys.psd2.model.ReportExchangeRate;
import de.adorsys.psd2.model.ReportExchangeRateList;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.domain.Xs2aExchangeRate;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardTransactionsReport;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", uses={AmountModelMapper.class, PurposeCodeMapper.class, Xs2aAddressMapper.class, AspspProfileServiceWrapper.class})
public abstract class CardAccountModelMapper {
    private static final List<MulticurrencyAccountLevel> MULTICURRENCY_ACCOUNT_AGGREGATION_LEVELS = Arrays.asList(MulticurrencyAccountLevel.AGGREGATION, MulticurrencyAccountLevel.AGGREGATION_AND_SUBACCOUNT);
    @Autowired
    protected HrefLinkMapper hrefLinkMapper;
    @Autowired
    protected AspspProfileServiceWrapper aspspProfileServiceWrapper;

    public CardAccountList mapToCardAccountList(Xs2aCardAccountListHolder xs2aCardAccountListHolder) {
        List<Xs2aCardAccountDetails> accountDetailsList = xs2aCardAccountListHolder.getCardAccountDetails();
        List details = accountDetailsList.stream().map(this::mapToCardAccountDetails).collect(Collectors.toList());
        return new CardAccountList().cardAccounts(details);
    }

    public InlineResponse2002 mapToInlineResponse202(Xs2aCardAccountDetailsHolder xs2aAccountDetailsHolder) {
        InlineResponse2002 inlineResponse202 = new InlineResponse2002();
        inlineResponse202.setCardAccount(this.mapToCardAccountDetails(xs2aAccountDetailsHolder.getCardAccountDetails()));
        return inlineResponse202;
    }

    @Mappings(value={@Mapping(target="_links", ignore=true), @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(accountDetails.getLinks()))"), @Mapping(target="status", source="accountStatus"), @Mapping(target="usage", source="usageType"), @Mapping(target="currency", expression="java(mapToAccountDetailsCurrency(accountDetails.getCurrency()))")})
    public abstract CardAccountDetails mapToCardAccountDetails(Xs2aCardAccountDetails var1);

    @Mappings(value={@Mapping(target="balanceType", expression="java(mapToBalanceType(balance.getBalanceType()))"), @Mapping(target="lastChangeDateTime", expression="java(mapToOffsetDateTime(balance.getLastChangeDateTime()))")})
    public abstract Balance mapToBalance(Xs2aBalance var1);

    @Mapping(target="cardAccount", expression="java(mapToCardAccount(balancesReport.getXs2aAccountReference()))")
    public abstract ReadCardAccountBalanceResponse200 mapToBalance(Xs2aBalancesReport var1);

    @Mappings(value={@Mapping(target="_links", ignore=true), @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(accountReport.getLinks()))")})
    public abstract CardAccountReport mapToCardAccountReport(Xs2aCardAccountReport var1);

    @Mappings(value={@Mapping(target="_links", ignore=true), @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(cardTransactionsReport.getLinks()))"), @Mapping(target="cardTransactions", source="cardAccountReport"), @Mapping(target="cardAccount", source="accountReference")})
    public abstract CardAccountsTransactionsResponse200 mapToTransactionsResponse200Json(Xs2aCardTransactionsReport var1);

    public byte[] mapToTransactionsResponseRaw(Xs2aCardTransactionsReport transactionsReport) {
        return transactionsReport.getCardAccountReport().getTransactionsRaw();
    }

    @Mapping(target="currencyExchange", expression="java(mapToReportExchanges(transactions.getCurrencyExchange()))")
    public abstract CardTransaction mapToCardTransaction(de.adorsys.psd2.xs2a.domain.CardTransaction var1);

    @Mappings(value={@Mapping(target="currency", source="currency.currencyCode"), @Mapping(target="other", expression="java(mapToOtherType(xs2aAccountReference.getOther()))")})
    public abstract AccountReference mapToCardAccount(de.adorsys.psd2.xs2a.core.profile.AccountReference var1);

    protected OffsetDateTime mapToOffsetDateTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        List<ZoneOffset> validOffsets = ZoneId.systemDefault().getRules().getValidOffsets(localDateTime);
        return localDateTime.atOffset(validOffsets.get(0));
    }

    protected BalanceType mapToBalanceType(de.adorsys.psd2.xs2a.domain.BalanceType balanceType) {
        if (balanceType == null) {
            return null;
        }
        return BalanceType.fromValue((String)balanceType.getValue());
    }

    protected BalanceList mapToBalanceList(List<Xs2aBalance> balances) {
        BalanceList balanceList = null;
        if (CollectionUtils.isNotEmpty(balances)) {
            balanceList = new BalanceList();
            balanceList.addAll((Collection)balances.stream().map(this::mapToBalance).collect(Collectors.toList()));
        }
        return balanceList;
    }

    @Nullable
    protected CardTransactionList mapToCardTransactionList(@Nullable List<de.adorsys.psd2.xs2a.domain.CardTransaction> transactions) {
        if (CollectionUtils.isEmpty(transactions)) {
            return null;
        }
        List transactionDetails = transactions.stream().map(this::mapToCardTransaction).collect(Collectors.toList());
        CardTransactionList transactionList = new CardTransactionList();
        transactionList.addAll(transactionDetails);
        return transactionList;
    }

    protected ReportExchangeRateList mapToReportExchanges(List<Xs2aExchangeRate> xs2aExchangeRates) {
        if (CollectionUtils.isEmpty(xs2aExchangeRates)) {
            return null;
        }
        return xs2aExchangeRates.stream().map(this::mapToReportExchangeRate).collect(Collectors.toCollection(ReportExchangeRateList::new));
    }

    protected abstract ReportExchangeRate mapToReportExchangeRate(Xs2aExchangeRate var1);

    protected String mapToAccountDetailsCurrency(Currency currency) {
        return Optional.ofNullable(currency).map(Currency::getCurrencyCode).orElseGet(this::getMulticurrencyRepresentationOrNull);
    }

    protected OtherType mapToOtherType(String other) {
        return other == null ? null : new OtherType().identification(other);
    }

    private String getMulticurrencyRepresentationOrNull() {
        return MULTICURRENCY_ACCOUNT_AGGREGATION_LEVELS.contains(this.aspspProfileServiceWrapper.getMulticurrencyAccountLevel()) ? "XXX" : null;
    }
}

