/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.link;

import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReportByPeriodRequest;
import de.adorsys.psd2.xs2a.service.link.BaseAspectService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.controller.AccountController;
import de.adorsys.psd2.xs2a.web.link.TransactionsReportDownloadLinks;
import de.adorsys.psd2.xs2a.web.link.Xs2aAccountReportLinks;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransactionAspectService
extends BaseAspectService<AccountController> {
    @Autowired
    public TransactionAspectService(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        super(aspspProfileServiceWrapper);
    }

    public ResponseObject<Xs2aTransactionsReport> getTransactionsReportByPeriod(ResponseObject<Xs2aTransactionsReport> result, Xs2aTransactionsReportByPeriodRequest request) {
        Xs2aTransactionsReport transactionsReport;
        if (!result.hasError() && (transactionsReport = result.getBody()) != null) {
            Xs2aAccountReport accountReport = transactionsReport.getAccountReport();
            if (accountReport != null) {
                accountReport.setLinks(new Xs2aAccountReportLinks(this.getHttpUrl(), request.getAccountId(), transactionsReport.getLinks()));
            }
            transactionsReport.setLinks(new TransactionsReportDownloadLinks(this.getHttpUrl(), request.getAccountId(), request.isWithBalance(), transactionsReport.getDownloadId()));
        }
        return result;
    }
}

