/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization;

import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiConsent;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationDecoupledScaResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonDecoupledConsentService<T extends SpiConsent> {
    private static final Logger log = LoggerFactory.getLogger(CommonDecoupledConsentService.class);
    private final SpiErrorMapper spiErrorMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aAuthorisationService authorisationService;

    public UpdateConsentPsuDataResponse proceedDecoupledApproach(String consentId, String authorisationId, T spiConsent, String authenticationMethodId, PsuIdData psuData) {
        SpiResponse<SpiAuthorisationDecoupledScaResponse> spiResponse = this.startScaDecoupled(this.spiContextDataProvider.provideWithPsuIdData(psuData), authorisationId, authenticationMethodId, spiConsent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, this.getServiceType());
            log.info("Consent-ID [{}], Authorisation-ID [{}], PSU-ID [{}], Authentication-Method-ID [{}]. Notifies a decoupled app about starting SCA when proceed decoupled approach has failed. Error msg: {}.", new Object[]{consentId, authorisationId, psuData.getPsuId(), authenticationMethodId, errorHolder});
            Optional first = errorHolder.getFirstErrorCode();
            if (first.isPresent() && first.get() == MessageErrorCode.PSU_CREDENTIALS_INVALID) {
                this.authorisationService.updateAuthorisationStatus(authorisationId, ScaStatus.FAILED);
            }
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
        }
        SpiAuthorisationDecoupledScaResponse spiAuthorisationDecoupledScaResponse = (SpiAuthorisationDecoupledScaResponse)spiResponse.getPayload();
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(spiAuthorisationDecoupledScaResponse.getScaStatus(), consentId, authorisationId, psuData);
        response.setPsuMessage(((SpiAuthorisationDecoupledScaResponse)spiResponse.getPayload()).getPsuMessage());
        return response;
    }

    protected abstract ServiceType getServiceType();

    protected abstract SpiResponse<SpiAuthorisationDecoupledScaResponse> startScaDecoupled(SpiContextData var1, String var2, String var3, T var4, SpiAspspConsentDataProvider var5);

    @ConstructorProperties(value={"spiErrorMapper", "aspspConsentDataProviderFactory", "spiContextDataProvider", "authorisationService"})
    public CommonDecoupledConsentService(SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiContextDataProvider spiContextDataProvider, Xs2aAuthorisationService authorisationService) {
        this.spiErrorMapper = spiErrorMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiContextDataProvider = spiContextDataProvider;
        this.authorisationService = authorisationService;
    }
}

