/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.service.ais.AccountServicesHolder;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBalanceService {
    private static final Logger log = LoggerFactory.getLogger(AbstractBalanceService.class);
    private final AccountServicesHolder accountServicesHolder;
    private final Xs2aEventService xs2aEventService;
    private final LoggingContextService loggingContextService;

    public ResponseObject<Xs2aBalancesReport> getBalancesReport(String consentId, String accountId, String requestUri) {
        this.xs2aEventService.recordConsentTppRequest(consentId, this.getEventType());
        Optional<AisConsent> aisConsentOptional = this.accountServicesHolder.getAccountConsentById(consentId);
        if (aisConsentOptional.isEmpty()) {
            log.info("Account-ID [{}], Consent-ID [{}]. Get balances report failed. Account consent not found by ID", (Object)accountId, (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AisConsent aisConsent = aisConsentOptional.get();
        ValidationResult validationResult = this.getValidationResultForCommonAccountBalanceRequest(accountId, requestUri, aisConsent);
        if (validationResult.isNotValid()) {
            log.info("Account-ID [{}], Consent-ID [{}], RequestUri [{}]. Get balances report - validation failed: {}", new Object[]{accountId, consentId, requestUri, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<List<SpiAccountBalance>> spiResponse = this.getSpiResponse(aisConsent, consentId, accountId);
        if (spiResponse.hasError()) {
            return this.checkSpiResponse(consentId, accountId, spiResponse);
        }
        this.loggingContextService.storeConsentStatus(aisConsent.getConsentStatus());
        return this.getXs2aBalancesReportResponseObject(aisConsent, accountId, consentId, requestUri, (List)spiResponse.getPayload());
    }

    protected abstract EventType getEventType();

    protected abstract ValidationResult getValidationResultForCommonAccountBalanceRequest(String var1, String var2, AisConsent var3);

    protected abstract SpiResponse<List<SpiAccountBalance>> getSpiResponse(AisConsent var1, String var2, String var3);

    protected abstract ResponseObject<Xs2aBalancesReport> checkSpiResponse(String var1, String var2, SpiResponse<List<SpiAccountBalance>> var3);

    protected abstract ResponseObject<Xs2aBalancesReport> getXs2aBalancesReportResponseObject(AisConsent var1, String var2, String var3, String var4, List<SpiAccountBalance> var5);

    @ConstructorProperties(value={"accountServicesHolder", "xs2aEventService", "loggingContextService"})
    public AbstractBalanceService(AccountServicesHolder accountServicesHolder, Xs2aEventService xs2aEventService, LoggingContextService loggingContextService) {
        this.accountServicesHolder = accountServicesHolder;
        this.xs2aEventService = xs2aEventService;
        this.loggingContextService = loggingContextService;
    }
}

