/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorisationsParameters;
import de.adorsys.psd2.xs2a.service.validator.piis.CommonConfirmationOfFundsConsentObject;
import de.adorsys.psd2.xs2a.service.validator.piis.CreatePiisConsentAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.DeleteConfirmationOfFundsConsentByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.GetConfirmationOfFundsConsentAuthorisationScaStatusPO;
import de.adorsys.psd2.xs2a.service.validator.piis.GetConfirmationOfFundsConsentAuthorisationScaStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.GetConfirmationOfFundsConsentAuthorisationsValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.UpdatePiisConsentPsuDataValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.dto.CreatePiisConsentAuthorisationObject;
import de.adorsys.psd2.xs2a.service.validator.piis.dto.UpdatePiisConsentPsuDataRequestObject;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class ConfirmationOfFundsConsentValidationService {
    private final DeleteConfirmationOfFundsConsentByIdValidator deleteConfirmationOfFundsConsentByIdValidator;
    private final CreatePiisConsentAuthorisationValidator createPiisConsentAuthorisationValidator;
    private final UpdatePiisConsentPsuDataValidator updatePiisConsentPsuDataValidator;
    private final GetConfirmationOfFundsConsentAuthorisationsValidator getCofConsentAuthorisationsValidator;
    private final GetConfirmationOfFundsConsentAuthorisationScaStatusValidator getCofConsentScaStatusValidator;

    public ValidationResult validateConsentOnDelete(PiisConsent consent) {
        return this.deleteConfirmationOfFundsConsentByIdValidator.validate(new CommonConfirmationOfFundsConsentObject(consent));
    }

    public ValidationResult validateConsentAuthorisationOnCreate(CreatePiisConsentAuthorisationObject createPiisConsentAuthorisationObject) {
        return this.createPiisConsentAuthorisationValidator.validate(createPiisConsentAuthorisationObject);
    }

    public ValidationResult validateConsentPsuDataOnUpdate(PiisConsent consent, ConsentAuthorisationsParameters request) {
        return this.updatePiisConsentPsuDataValidator.validate(new UpdatePiisConsentPsuDataRequestObject(consent, request));
    }

    public ValidationResult validateConsentAuthorisationOnGettingById(PiisConsent consent) {
        return this.getCofConsentAuthorisationsValidator.validate(new CommonConfirmationOfFundsConsentObject(consent));
    }

    public ValidationResult validateConsentAuthorisationScaStatus(PiisConsent consent, String authorisationId) {
        return this.getCofConsentScaStatusValidator.validate(new GetConfirmationOfFundsConsentAuthorisationScaStatusPO(consent, authorisationId));
    }

    @ConstructorProperties(value={"deleteConfirmationOfFundsConsentByIdValidator", "createPiisConsentAuthorisationValidator", "updatePiisConsentPsuDataValidator", "getCofConsentAuthorisationsValidator", "getCofConsentScaStatusValidator"})
    public ConfirmationOfFundsConsentValidationService(DeleteConfirmationOfFundsConsentByIdValidator deleteConfirmationOfFundsConsentByIdValidator, CreatePiisConsentAuthorisationValidator createPiisConsentAuthorisationValidator, UpdatePiisConsentPsuDataValidator updatePiisConsentPsuDataValidator, GetConfirmationOfFundsConsentAuthorisationsValidator getCofConsentAuthorisationsValidator, GetConfirmationOfFundsConsentAuthorisationScaStatusValidator getCofConsentScaStatusValidator) {
        this.deleteConfirmationOfFundsConsentByIdValidator = deleteConfirmationOfFundsConsentByIdValidator;
        this.createPiisConsentAuthorisationValidator = createPiisConsentAuthorisationValidator;
        this.updatePiisConsentPsuDataValidator = updatePiisConsentPsuDataValidator;
        this.getCofConsentAuthorisationsValidator = getCofConsentAuthorisationsValidator;
        this.getCofConsentScaStatusValidator = getCofConsentScaStatusValidator;
    }
}

