package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.core.data.piis.PiisConsentData;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.consent.ConsentTppInformation;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.spi.domain.piis.SpiPiisConsent;
import java.time.LocalDate;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-12-20T14:24:09+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.13 (Azul Systems, Inc.)"
)
@Component
public class Xs2aToSpiPiisConsentMapperImpl implements Xs2aToSpiPiisConsentMapper {

    @Autowired
    private Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper;

    @Override
    public SpiPiisConsent mapToSpiPiisConsent(PiisConsent piisConsent) {
        if ( piisConsent == null ) {
            return null;
        }

        SpiPiisConsent spiPiisConsent = new SpiPiisConsent();

        spiPiisConsent.setCardExpiryDate( piisConsentConsentDataCardExpiryDate( piisConsent ) );
        spiPiisConsent.setCardInformation( piisConsentConsentDataCardInformation( piisConsent ) );
        spiPiisConsent.setCardNumber( piisConsentConsentDataCardNumber( piisConsent ) );
        spiPiisConsent.setPsuData( xs2aToSpiPsuDataMapper.mapToSpiPsuDataList( piisConsent.getPsuIdDataList() ) );
        spiPiisConsent.setRegistrationInformation( piisConsentConsentDataRegistrationInformation( piisConsent ) );
        spiPiisConsent.setRequestDateTime( piisConsent.getCreationTimestamp() );
        spiPiisConsent.setTppAuthorisationNumber( piisConsentConsentTppInformationTppInfoAuthorisationNumber( piisConsent ) );
        spiPiisConsent.setId( piisConsent.getId() );
        spiPiisConsent.setRecurringIndicator( piisConsent.isRecurringIndicator() );
        spiPiisConsent.setLastActionDate( piisConsent.getLastActionDate() );
        spiPiisConsent.setExpireDate( piisConsent.getExpireDate() );
        spiPiisConsent.setConsentStatus( piisConsent.getConsentStatus() );
        spiPiisConsent.setCreationTimestamp( piisConsent.getCreationTimestamp() );
        spiPiisConsent.setInstanceId( piisConsent.getInstanceId() );
        spiPiisConsent.setStatusChangeTimestamp( piisConsent.getStatusChangeTimestamp() );
        spiPiisConsent.setConsentType( piisConsent.getConsentType() );

        spiPiisConsent.setAccount( toSpiAccountReference(piisConsent.getAccountReference()) );

        return spiPiisConsent;
    }

    private LocalDate piisConsentConsentDataCardExpiryDate(PiisConsent piisConsent) {
        if ( piisConsent == null ) {
            return null;
        }
        PiisConsentData consentData = piisConsent.getConsentData();
        if ( consentData == null ) {
            return null;
        }
        LocalDate cardExpiryDate = consentData.getCardExpiryDate();
        if ( cardExpiryDate == null ) {
            return null;
        }
        return cardExpiryDate;
    }

    private String piisConsentConsentDataCardInformation(PiisConsent piisConsent) {
        if ( piisConsent == null ) {
            return null;
        }
        PiisConsentData consentData = piisConsent.getConsentData();
        if ( consentData == null ) {
            return null;
        }
        String cardInformation = consentData.getCardInformation();
        if ( cardInformation == null ) {
            return null;
        }
        return cardInformation;
    }

    private String piisConsentConsentDataCardNumber(PiisConsent piisConsent) {
        if ( piisConsent == null ) {
            return null;
        }
        PiisConsentData consentData = piisConsent.getConsentData();
        if ( consentData == null ) {
            return null;
        }
        String cardNumber = consentData.getCardNumber();
        if ( cardNumber == null ) {
            return null;
        }
        return cardNumber;
    }

    private String piisConsentConsentDataRegistrationInformation(PiisConsent piisConsent) {
        if ( piisConsent == null ) {
            return null;
        }
        PiisConsentData consentData = piisConsent.getConsentData();
        if ( consentData == null ) {
            return null;
        }
        String registrationInformation = consentData.getRegistrationInformation();
        if ( registrationInformation == null ) {
            return null;
        }
        return registrationInformation;
    }

    private String piisConsentConsentTppInformationTppInfoAuthorisationNumber(PiisConsent piisConsent) {
        if ( piisConsent == null ) {
            return null;
        }
        ConsentTppInformation consentTppInformation = piisConsent.getConsentTppInformation();
        if ( consentTppInformation == null ) {
            return null;
        }
        TppInfo tppInfo = consentTppInformation.getTppInfo();
        if ( tppInfo == null ) {
            return null;
        }
        String authorisationNumber = tppInfo.getAuthorisationNumber();
        if ( authorisationNumber == null ) {
            return null;
        }
        return authorisationNumber;
    }
}
