package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.MonthsOfExecution;
import de.adorsys.psd2.model.OtherType;
import de.adorsys.psd2.model.PaymentInitiationBulkElementJson;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.model.RemittanceInformationStructured;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.pis.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-12-20T14:24:08+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.13 (Azul Systems, Inc.)"
)
@Component
public class PaymentModelMapperImpl implements PaymentModelMapper {

    @Autowired
    private Xs2aAddressMapper xs2aAddressMapper;
    @Autowired
    private PurposeCodeMapper purposeCodeMapper;

    @Override
    public PeriodicPayment mapToXs2aPayment(PeriodicPaymentInitiationJson paymentRequest) {
        if ( paymentRequest == null ) {
            return null;
        }

        PeriodicPayment periodicPayment = new PeriodicPayment();

        periodicPayment.setCreditorId( paymentRequest.getCreditorId() );
        periodicPayment.setEndToEndIdentification( paymentRequest.getEndToEndIdentification() );
        periodicPayment.setInstructionIdentification( paymentRequest.getInstructionIdentification() );
        periodicPayment.setDebtorAccount( mapToAccountReference( paymentRequest.getDebtorAccount() ) );
        periodicPayment.setUltimateDebtor( paymentRequest.getUltimateDebtor() );
        periodicPayment.setInstructedAmount( mapToXs2aAmount( paymentRequest.getInstructedAmount() ) );
        periodicPayment.setCreditorAccount( mapToAccountReference( paymentRequest.getCreditorAccount() ) );
        periodicPayment.setCreditorAgent( paymentRequest.getCreditorAgent() );
        periodicPayment.setCreditorName( paymentRequest.getCreditorName() );
        periodicPayment.setCreditorAddress( xs2aAddressMapper.mapToXs2aAddress( paymentRequest.getCreditorAddress() ) );
        periodicPayment.setUltimateCreditor( paymentRequest.getUltimateCreditor() );
        periodicPayment.setPurposeCode( purposeCodeMapper.mapToPurposeCode( paymentRequest.getPurposeCode() ) );
        periodicPayment.setRemittanceInformationUnstructured( paymentRequest.getRemittanceInformationUnstructured() );
        periodicPayment.setRemittanceInformationStructured( paymentRequest.getRemittanceInformationStructured() );
        periodicPayment.setDebtorName( paymentRequest.getDebtorName() );
        periodicPayment.setStartDate( paymentRequest.getStartDate() );
        periodicPayment.setExecutionRule( executionRuleToPisExecutionRule( paymentRequest.getExecutionRule() ) );
        periodicPayment.setEndDate( paymentRequest.getEndDate() );
        periodicPayment.setFrequency( frequencyCodeToFrequencyCode( paymentRequest.getFrequency() ) );
        MonthsOfExecution monthsOfExecution = paymentRequest.getMonthsOfExecution();
        if ( monthsOfExecution != null ) {
            periodicPayment.setMonthsOfExecution( new ArrayList<String>( monthsOfExecution ) );
        }

        periodicPayment.setDayOfExecution( mapDayOfExecution(paymentRequest.getDayOfExecution()) );
        periodicPayment.setRemittanceInformationStructuredArray( mapToRemittanceInformationStructuredString(paymentRequest.getRemittanceInformationStructuredArray()) );

        return periodicPayment;
    }

    @Override
    public SinglePayment mapToXs2aPayment(PaymentInitiationJson paymentRequest) {
        if ( paymentRequest == null ) {
            return null;
        }

        SinglePayment singlePayment = new SinglePayment();

        singlePayment.setCreditorId( paymentRequest.getCreditorId() );
        singlePayment.setEndToEndIdentification( paymentRequest.getEndToEndIdentification() );
        singlePayment.setInstructionIdentification( paymentRequest.getInstructionIdentification() );
        singlePayment.setDebtorAccount( mapToAccountReference( paymentRequest.getDebtorAccount() ) );
        singlePayment.setUltimateDebtor( paymentRequest.getUltimateDebtor() );
        singlePayment.setInstructedAmount( mapToXs2aAmount( paymentRequest.getInstructedAmount() ) );
        singlePayment.setCreditorAccount( mapToAccountReference( paymentRequest.getCreditorAccount() ) );
        singlePayment.setCreditorAgent( paymentRequest.getCreditorAgent() );
        singlePayment.setCreditorName( paymentRequest.getCreditorName() );
        singlePayment.setCreditorAddress( xs2aAddressMapper.mapToXs2aAddress( paymentRequest.getCreditorAddress() ) );
        singlePayment.setUltimateCreditor( paymentRequest.getUltimateCreditor() );
        singlePayment.setPurposeCode( purposeCodeMapper.mapToPurposeCode( paymentRequest.getPurposeCode() ) );
        singlePayment.setRemittanceInformationUnstructured( paymentRequest.getRemittanceInformationUnstructured() );
        singlePayment.setRemittanceInformationStructured( paymentRequest.getRemittanceInformationStructured() );
        singlePayment.setRemittanceInformationStructuredArray( mapToRemittanceInformationStructuredString( paymentRequest.getRemittanceInformationStructuredArray() ) );
        singlePayment.setRequestedExecutionDate( paymentRequest.getRequestedExecutionDate() );
        singlePayment.setDebtorName( paymentRequest.getDebtorName() );
        singlePayment.setChargeBearer( paymentRequest.getChargeBearer() );

        return singlePayment;
    }

    @Override
    public BulkPayment mapToXs2aPayment(BulkPaymentInitiationJson paymentRequest) {
        if ( paymentRequest == null ) {
            return null;
        }

        BulkPayment bulkPayment = new BulkPayment();

        bulkPayment.setDebtorAccount( mapToAccountReference( paymentRequest.getDebtorAccount() ) );
        bulkPayment.setDebtorName( paymentRequest.getDebtorName() );
        bulkPayment.setRequestedExecutionDate( paymentRequest.getRequestedExecutionDate() );
        bulkPayment.setRequestedExecutionTime( paymentRequest.getRequestedExecutionTime() );
        bulkPayment.setPayments( paymentInitiationBulkElementJsonListToSinglePaymentList( paymentRequest.getPayments() ) );
        bulkPayment.setBatchBookingPreferred( paymentRequest.getBatchBookingPreferred() );

        mapToXs2aPaymentAfterMapping( paymentRequest, bulkPayment );

        return bulkPayment;
    }

    @Override
    public Xs2aAmount mapToXs2aAmount(Amount amount) {
        if ( amount == null ) {
            return null;
        }

        Xs2aAmount xs2aAmount = new Xs2aAmount();

        if ( amount.getCurrency() != null ) {
            xs2aAmount.setCurrency( Currency.getInstance( amount.getCurrency() ) );
        }
        xs2aAmount.setAmount( amount.getAmount() );

        return xs2aAmount;
    }

    @Override
    public de.adorsys.psd2.xs2a.core.profile.AccountReference mapToAccountReference(AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference1 = new de.adorsys.psd2.xs2a.core.profile.AccountReference();

        accountReference1.setOther( accountReferenceOtherIdentification( accountReference ) );
        accountReference1.setIban( accountReference.getIban() );
        accountReference1.setBban( accountReference.getBban() );
        accountReference1.setPan( accountReference.getPan() );
        accountReference1.setMaskedPan( accountReference.getMaskedPan() );
        accountReference1.setMsisdn( accountReference.getMsisdn() );
        if ( accountReference.getCurrency() != null ) {
            accountReference1.setCurrency( Currency.getInstance( accountReference.getCurrency() ) );
        }
        accountReference1.setCashAccountType( accountReference.getCashAccountType() );

        return accountReference1;
    }

    protected PisExecutionRule executionRuleToPisExecutionRule(ExecutionRule executionRule) {
        if ( executionRule == null ) {
            return null;
        }

        PisExecutionRule pisExecutionRule;

        switch ( executionRule ) {
            case FOLLOWING: pisExecutionRule = PisExecutionRule.FOLLOWING;
            break;
            case PRECEDING: pisExecutionRule = PisExecutionRule.PRECEDING;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + executionRule );
        }

        return pisExecutionRule;
    }

    protected de.adorsys.psd2.xs2a.core.pis.FrequencyCode frequencyCodeToFrequencyCode(FrequencyCode frequencyCode) {
        if ( frequencyCode == null ) {
            return null;
        }

        de.adorsys.psd2.xs2a.core.pis.FrequencyCode frequencyCode1;

        switch ( frequencyCode ) {
            case DAILY: frequencyCode1 = de.adorsys.psd2.xs2a.core.pis.FrequencyCode.DAILY;
            break;
            case WEEKLY: frequencyCode1 = de.adorsys.psd2.xs2a.core.pis.FrequencyCode.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCode1 = de.adorsys.psd2.xs2a.core.pis.FrequencyCode.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCode1 = de.adorsys.psd2.xs2a.core.pis.FrequencyCode.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCode1 = de.adorsys.psd2.xs2a.core.pis.FrequencyCode.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCode1 = de.adorsys.psd2.xs2a.core.pis.FrequencyCode.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCode1 = de.adorsys.psd2.xs2a.core.pis.FrequencyCode.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCode1 = de.adorsys.psd2.xs2a.core.pis.FrequencyCode.ANNUAL;
            break;
            case MONTHLYVARIABLE: frequencyCode1 = de.adorsys.psd2.xs2a.core.pis.FrequencyCode.MONTHLYVARIABLE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCode );
        }

        return frequencyCode1;
    }

    protected SinglePayment paymentInitiationBulkElementJsonToSinglePayment(PaymentInitiationBulkElementJson paymentInitiationBulkElementJson) {
        if ( paymentInitiationBulkElementJson == null ) {
            return null;
        }

        SinglePayment singlePayment = new SinglePayment();

        singlePayment.setCreditorId( paymentInitiationBulkElementJson.getCreditorId() );
        singlePayment.setEndToEndIdentification( paymentInitiationBulkElementJson.getEndToEndIdentification() );
        singlePayment.setInstructionIdentification( paymentInitiationBulkElementJson.getInstructionIdentification() );
        singlePayment.setUltimateDebtor( paymentInitiationBulkElementJson.getUltimateDebtor() );
        singlePayment.setInstructedAmount( mapToXs2aAmount( paymentInitiationBulkElementJson.getInstructedAmount() ) );
        singlePayment.setCreditorAccount( mapToAccountReference( paymentInitiationBulkElementJson.getCreditorAccount() ) );
        singlePayment.setCreditorAgent( paymentInitiationBulkElementJson.getCreditorAgent() );
        singlePayment.setCreditorName( paymentInitiationBulkElementJson.getCreditorName() );
        singlePayment.setCreditorAddress( xs2aAddressMapper.mapToXs2aAddress( paymentInitiationBulkElementJson.getCreditorAddress() ) );
        singlePayment.setUltimateCreditor( paymentInitiationBulkElementJson.getUltimateCreditor() );
        singlePayment.setPurposeCode( purposeCodeMapper.mapToPurposeCode( paymentInitiationBulkElementJson.getPurposeCode() ) );
        singlePayment.setRemittanceInformationUnstructured( paymentInitiationBulkElementJson.getRemittanceInformationUnstructured() );
        singlePayment.setRemittanceInformationStructured( paymentInitiationBulkElementJson.getRemittanceInformationStructured() );
        singlePayment.setRemittanceInformationStructuredArray( mapToRemittanceInformationStructuredString( paymentInitiationBulkElementJson.getRemittanceInformationStructuredArray() ) );
        singlePayment.setDebtorName( paymentInitiationBulkElementJson.getDebtorName() );
        singlePayment.setChargeBearer( paymentInitiationBulkElementJson.getChargeBearer() );

        return singlePayment;
    }

    protected List<SinglePayment> paymentInitiationBulkElementJsonListToSinglePaymentList(List<PaymentInitiationBulkElementJson> list) {
        if ( list == null ) {
            return null;
        }

        List<SinglePayment> list1 = new ArrayList<SinglePayment>( list.size() );
        for ( PaymentInitiationBulkElementJson paymentInitiationBulkElementJson : list ) {
            list1.add( paymentInitiationBulkElementJsonToSinglePayment( paymentInitiationBulkElementJson ) );
        }

        return list1;
    }

    private String accountReferenceOtherIdentification(AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }
        OtherType other = accountReference.getOther();
        if ( other == null ) {
            return null;
        }
        String identification = other.getIdentification();
        if ( identification == null ) {
            return null;
        }
        return identification;
    }
}
