package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.TrustedBeneficiary;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTrustedBeneficiaries;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-11-17T09:56:22+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.13 (Azul Systems, Inc.)"
)
@Component
public class TrustedBeneficiariesModelMapperImpl implements TrustedBeneficiariesModelMapper {

    @Autowired
    private Xs2aAddressMapper xs2aAddressMapper;

    @Override
    public TrustedBeneficiary mapToTrustedBeneficiaries(Xs2aTrustedBeneficiaries trustedBeneficiaries) {
        if ( trustedBeneficiaries == null ) {
            return null;
        }

        TrustedBeneficiary trustedBeneficiary = new TrustedBeneficiary();

        trustedBeneficiary.setTrustedBeneficiaryId( trustedBeneficiaries.getTrustedBeneficiaryId() );
        trustedBeneficiary.setCreditorAgent( trustedBeneficiaries.getCreditorAgent() );
        trustedBeneficiary.setCreditorName( trustedBeneficiaries.getCreditorName() );
        trustedBeneficiary.setCreditorAlias( trustedBeneficiaries.getCreditorAlias() );
        trustedBeneficiary.setCreditorId( trustedBeneficiaries.getCreditorId() );
        trustedBeneficiary.setCreditorAddress( xs2aAddressMapper.mapToAddress( trustedBeneficiaries.getCreditorAddress() ) );

        trustedBeneficiary.setCreditorAccount( mapToAccountReference(trustedBeneficiaries.getCreditorAccount()) );
        trustedBeneficiary.setDebtorAccount( mapToAccountReference(trustedBeneficiaries.getDebtorAccount()) );

        return trustedBeneficiary;
    }

    @Override
    public AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference value) {
        if ( value == null ) {
            return null;
        }

        AccountReference accountReference = new AccountReference();

        accountReference.setIban( value.getIban() );
        accountReference.setBban( value.getBban() );
        accountReference.setPan( value.getPan() );
        accountReference.setMaskedPan( value.getMaskedPan() );
        accountReference.setMsisdn( value.getMsisdn() );
        accountReference.setCashAccountType( value.getCashAccountType() );

        accountReference.setCurrency( mapToCurrency(value.getCurrency()) );
        accountReference.setOther( mapToOtherType(value.getOther()) );

        return accountReference;
    }
}
