/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment.handler.type;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AmountValidator;
import de.adorsys.psd2.xs2a.web.validator.body.FieldLengthValidator;
import de.adorsys.psd2.xs2a.web.validator.body.IbanValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.config.PaymentValidationConfig;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.service.CustomPaymentValidationService;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.type.SinglePaymentTypeValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.payment.mapper.PaymentMapper;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BulkPaymentTypeValidatorImpl
extends SinglePaymentTypeValidatorImpl {
    private final CustomPaymentValidationService customPaymentValidationService;
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    @Autowired
    public BulkPaymentTypeValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper, PaymentMapper paymentMapper, AmountValidator amountValidator, IbanValidator ibanValidator, CustomPaymentValidationService customPaymentValidationService, FieldLengthValidator fieldLengthValidator, AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        super(errorBuildingService, xs2aObjectMapper, paymentMapper, amountValidator, ibanValidator, customPaymentValidationService, fieldLengthValidator, aspspProfileServiceWrapper);
        this.customPaymentValidationService = customPaymentValidationService;
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.BULK;
    }

    @Override
    public MessageError validate(Object body, MessageError messageError, PaymentValidationConfig validationConfig) {
        try {
            this.doBulkValidation(this.paymentMapper.mapToBulkPayment(body), messageError, validationConfig);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("Unrecognized field")) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_EXTRA_FIELD, (Object[])new Object[]{this.extractErrorField(e.getMessage())}));
            }
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR));
        }
        return messageError;
    }

    void doBulkValidation(BulkPayment bulkPayment, MessageError messageError, PaymentValidationConfig validationConfig) {
        if (bulkPayment.getDebtorAccount() != null) {
            this.validateAccount(bulkPayment.getDebtorAccount(), messageError, validationConfig);
        } else if (!this.aspspProfileServiceWrapper.isDebtorAccountOptionalInInitialRequest()) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"debtorAccount"}));
        }
        List<SinglePayment> payments = bulkPayment.getPayments();
        if (CollectionUtils.isEmpty(payments)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_BULK));
        } else {
            payments.forEach(singlePayment -> super.doSingleValidation((SinglePayment)singlePayment, messageError, validationConfig));
        }
        if (this.isDateInThePast(bulkPayment.getRequestedExecutionDate())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.EXECUTION_DATE_INVALID_IN_THE_PAST));
        }
        this.customPaymentValidationService.performCustomBulkValidation(bulkPayment, messageError, validationConfig);
    }
}

