/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentCancellationRequest;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.ChosenScaMethod;
import de.adorsys.psd2.model.PaymentInitationRequestResponse201;
import de.adorsys.psd2.model.PaymentInitiationCancelResponse202;
import de.adorsys.psd2.model.PaymentInitiationStatusResponse200Json;
import de.adorsys.psd2.model.ScaStatus;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppAttributes;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aChosenScaMethod;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.GetPaymentStatusResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.exception.WrongPaymentTypeException;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.ScaMethodsMapper;
import de.adorsys.psd2.xs2a.web.mapper.TppMessage200Mapper;
import de.adorsys.psd2.xs2a.web.mapper.TppMessage201Mapper;
import de.adorsys.psd2.xs2a.web.mapper.TppMessageGenericMapper;
import de.adorsys.psd2.xs2a.web.mapper.TppRedirectUriMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentModelMapperPsd2 {
    private static final Logger log = LoggerFactory.getLogger(PaymentModelMapperPsd2.class);
    private final CoreObjectsMapper coreObjectsMapper;
    private final TppRedirectUriMapper tppRedirectUriMapper;
    private final AmountModelMapper amountModelMapper;
    private final HrefLinkMapper hrefLinkMapper;
    private final ScaMethodsMapper scaMethodsMapper;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private final Xs2aObjectMapper xs2aObjectMapper;
    private final TppMessage200Mapper tppMessage200Mapper;
    private final TppMessage201Mapper tppMessage201Mapper;
    private final TppMessageGenericMapper tppMessageGenericMapper;

    public Object mapToGetPaymentResponse(CommonPayment commonPayment) {
        String rawData = this.convertResponseToRawData(commonPayment.getPaymentData());
        return this.standardPaymentProductsResolver.isRawPaymentProduct(commonPayment.getPaymentProduct()) ? rawData : this.enrichPaymentWithAdditionalData(rawData, commonPayment);
    }

    private Object enrichPaymentWithAdditionalData(String rawData, CommonPayment commonPayment) {
        try {
            Map map = (Map)this.xs2aObjectMapper.readValue(rawData, Map.class);
            map.put("transactionStatus", commonPayment.getTransactionStatus().toString());
            return map;
        }
        catch (JsonProcessingException e) {
            log.warn("Can't convert payment to map {}", (Object)e.getMessage());
            return rawData;
        }
    }

    public PaymentInitiationStatusResponse200Json mapToStatusResponseJson(GetPaymentStatusResponse response) {
        return new PaymentInitiationStatusResponse200Json().transactionStatus(this.mapToTransactionStatus(response.getTransactionStatus())).fundsAvailable(response.getFundsAvailable()).psuMessage(response.getPsuMessage())._links(this.hrefLinkMapper.mapToLinksMap(response.getLinks())).tppMessage(this.tppMessage200Mapper.mapToTppMessage200List(response.getTppMessageInformation()));
    }

    public byte[] mapToStatusResponseRaw(GetPaymentStatusResponse response) {
        return response.getPaymentStatusRaw();
    }

    public PaymentInitationRequestResponse201 mapToPaymentInitiationResponse(PaymentInitiationResponse response) {
        PaymentInitationRequestResponse201 response201 = new PaymentInitationRequestResponse201();
        response201.setTransactionStatus(this.mapToTransactionStatus(response.getTransactionStatus()));
        response201.setPaymentId(response.getPaymentId());
        response201.setTransactionFees(this.amountModelMapper.mapToAmount(response.getTransactionFees()));
        response201.setTransactionFeeIndicator(response.getTransactionFeeIndicator());
        response201.setScaMethods(this.scaMethodsMapper.mapToScaMethods(response.getScaMethods()));
        response201.setChallengeData(this.coreObjectsMapper.mapToChallengeData(response.getChallengeData()));
        response201.setLinks(this.hrefLinkMapper.mapToLinksMap(response.getLinks()));
        response201.setPsuMessage(response.getPsuMessage());
        response201.setTppMessages(this.tppMessage201Mapper.mapToTppMessage201List(response.getTppMessageInformation()));
        response201.setCurrencyConversionFee(this.amountModelMapper.mapToAmount(response.getCurrencyConversionFee()));
        response201.setEstimatedTotalAmount(this.amountModelMapper.mapToAmount(response.getEstimatedTotalAmount()));
        response201.setEstimatedInterbankSettlementAmount(this.amountModelMapper.mapToAmount(response.getEstimatedInterbankSettlementAmount()));
        response201.setScaStatus((ScaStatus)Optional.ofNullable(response.getScaStatus()).map(this.coreObjectsMapper::mapToModelScaStatus).orElse(null));
        return response201;
    }

    public PaymentInitiationParameters mapToPaymentRequestParameters(String paymentProduct, String paymentService, TppAttributes tppAttributes, PsuIdData psuData, String instanceId) {
        PaymentInitiationParameters parameters = new PaymentInitiationParameters();
        parameters.setPaymentType((PaymentType)PaymentType.getByValue((String)paymentService).orElseThrow(() -> new WrongPaymentTypeException(paymentService)));
        parameters.setPaymentProduct(Optional.ofNullable(paymentProduct).orElseThrow(() -> new IllegalArgumentException("Unsupported payment product")));
        parameters.setQwacCertificate(new String(Optional.ofNullable(tppAttributes.getTppSignatureCertificate()).orElse(new byte[0]), StandardCharsets.UTF_8));
        parameters.setTppRedirectUri(this.tppRedirectUriMapper.mapToTppRedirectUri(tppAttributes.getTppRedirectURI(), tppAttributes.getTppNokRedirectURI()));
        parameters.setTppExplicitAuthorisationPreferred(tppAttributes.isTppExplicitAuthorisationPreferred());
        parameters.setPsuData(psuData);
        parameters.setTppNotificationData(tppAttributes.getTppNotificationData());
        parameters.setTppBrandLoggingInformation(tppAttributes.getTppBrandLoggingInformation());
        parameters.setInstanceId(instanceId);
        return parameters;
    }

    public PisPaymentCancellationRequest mapToPaymentCancellationRequest(String paymentProduct, String paymentService, String paymentId, Boolean tppExplicitAuthorisationPreferred, String tpPRedirectURI, String tpPNokRedirectURI) {
        return new PisPaymentCancellationRequest((PaymentType)PaymentType.getByValue((String)paymentService).orElseThrow(() -> new WrongPaymentTypeException(paymentService)), Optional.ofNullable(paymentProduct).orElseThrow(() -> new IllegalArgumentException("Unsupported payment product")), paymentId, Boolean.valueOf(BooleanUtils.isTrue((Boolean)tppExplicitAuthorisationPreferred)), this.tppRedirectUriMapper.mapToTppRedirectUri(tpPRedirectURI, tpPNokRedirectURI));
    }

    public PaymentInitiationCancelResponse202 mapToPaymentInitiationCancelResponse(CancelPaymentResponse cancelPaymentResponse) {
        PaymentInitiationCancelResponse202 response = new PaymentInitiationCancelResponse202();
        response.setTransactionStatus(this.mapToTransactionStatus(cancelPaymentResponse.getTransactionStatus()));
        response.setScaMethods(this.scaMethodsMapper.mapToScaMethods(cancelPaymentResponse.getScaMethods()));
        response.setChosenScaMethod(this.mapToChosenScaMethod(cancelPaymentResponse.getChosenScaMethod()));
        response.setChallengeData(this.coreObjectsMapper.mapToChallengeData(cancelPaymentResponse.getChallengeData()));
        response._links(this.hrefLinkMapper.mapToLinksMap(cancelPaymentResponse.getLinks()));
        response.setTppMessages(this.tppMessageGenericMapper.mapToTppMessageGenericList(cancelPaymentResponse.getTppMessageInformation()));
        response.setPsuMessage(cancelPaymentResponse.getPsuMessage());
        response.setScaStatus((ScaStatus)Optional.ofNullable(cancelPaymentResponse.getScaStatus()).map(this.coreObjectsMapper::mapToModelScaStatus).orElse(null));
        return response;
    }

    private de.adorsys.psd2.model.TransactionStatus mapToTransactionStatus(TransactionStatus responseObject) {
        return Optional.ofNullable(responseObject).map(r -> de.adorsys.psd2.model.TransactionStatus.valueOf((String)r.name())).orElse(null);
    }

    private ChosenScaMethod mapToChosenScaMethod(Xs2aChosenScaMethod xs2aChosenScaMethod) {
        return Optional.ofNullable(xs2aChosenScaMethod).map(ch -> {
            ChosenScaMethod method = new ChosenScaMethod();
            method.setAuthenticationMethodId(ch.getAuthenticationMethodId());
            method.setAuthenticationType(ch.getAuthenticationType());
            return method;
        }).orElse(null);
    }

    private String convertResponseToRawData(byte[] paymentData) {
        try {
            return IOUtils.toString((byte[])paymentData, (String)Charset.defaultCharset().name());
        }
        catch (IOException e) {
            log.warn("Can not convert payment from byte[] ", (Throwable)e);
            return null;
        }
    }

    @ConstructorProperties(value={"coreObjectsMapper", "tppRedirectUriMapper", "amountModelMapper", "hrefLinkMapper", "scaMethodsMapper", "standardPaymentProductsResolver", "xs2aObjectMapper", "tppMessage200Mapper", "tppMessage201Mapper", "tppMessageGenericMapper"})
    public PaymentModelMapperPsd2(CoreObjectsMapper coreObjectsMapper, TppRedirectUriMapper tppRedirectUriMapper, AmountModelMapper amountModelMapper, HrefLinkMapper hrefLinkMapper, ScaMethodsMapper scaMethodsMapper, StandardPaymentProductsResolver standardPaymentProductsResolver, Xs2aObjectMapper xs2aObjectMapper, TppMessage200Mapper tppMessage200Mapper, TppMessage201Mapper tppMessage201Mapper, TppMessageGenericMapper tppMessageGenericMapper) {
        this.coreObjectsMapper = coreObjectsMapper;
        this.tppRedirectUriMapper = tppRedirectUriMapper;
        this.amountModelMapper = amountModelMapper;
        this.hrefLinkMapper = hrefLinkMapper;
        this.scaMethodsMapper = scaMethodsMapper;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.xs2aObjectMapper = xs2aObjectMapper;
        this.tppMessage200Mapper = tppMessage200Mapper;
        this.tppMessage201Mapper = tppMessage201Mapper;
        this.tppMessageGenericMapper = tppMessageGenericMapper;
    }
}

