/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.xs2a.domain.EntryDetails;
import de.adorsys.psd2.xs2a.domain.TransactionInfo;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aExchangeRateMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiEntryDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionInfo;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring", uses={SpiToXs2aAmountMapper.class, SpiToXs2aBalanceMapper.class, SpiToXs2aExchangeRateMapper.class, SpiToXs2aAccountReferenceMapper.class}, imports={PurposeCode.class, BankTransactionCode.class})
public interface SpiToXs2aTransactionMapper {
    @Mappings(value={@Mapping(target="amount", source="spiAmount"), @Mapping(target="bankTransactionCodeCode", expression="java(new BankTransactionCode(spiTransaction.getBankTransactionCodeCode()))"), @Mapping(target="transactionInfo", source="spiTransactionInfo")})
    public Transactions mapToXs2aTransaction(SpiTransaction var1);

    public List<Transactions> mapToXs2aTransactionList(List<SpiTransaction> var1);

    @Mapping(target="transactionInfo", source="spiTransactionInfo")
    public EntryDetails mapToEntryDetails(SpiEntryDetails var1);

    public List<EntryDetails> mapToEntryDetailsList(List<SpiEntryDetails> var1);

    @Mapping(target="purposeCode", expression="java(PurposeCode.fromValue(spiTransactionInfo.getPurposeCode()))")
    public TransactionInfo mapToTransactionInfo(SpiTransactionInfo var1);
}

