/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.sb;

import de.adorsys.psd2.model.Error404NGSBS;
import de.adorsys.psd2.model.TppMessage404SBS;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SB404ErrorMapper
extends Psd2ErrorMapper<MessageError, Error404NGSBS> {
    @Override
    public Function<MessageError, Error404NGSBS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.NOT_FOUND;
    }

    private Error404NGSBS mapToPsd2Error(MessageError messageError) {
        return new Error404NGSBS().tppMessages(this.mapToTppMessage404SB(messageError.getTppMessages()));
    }

    private List<TppMessage404SBS> mapToTppMessage404SB(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage404SBS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(m.getMessageErrorCode().getName()).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

