/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.piis;

import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.exception.model.error500.Error500NGPIIS;
import de.adorsys.psd2.xs2a.exception.model.error500.TppMessage500PIIS;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class PIIS500ErrorMapper
extends Psd2ErrorMapper<MessageError, Error500NGPIIS> {
    @Override
    public Function<MessageError, Error500NGPIIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    private Error500NGPIIS mapToPsd2Error(MessageError messageError) {
        return ((Error500NGPIIS.Error500NGPIISBuilder)Error500NGPIIS.builder().tppMessages(this.mapToTppMessage500PIIS(messageError.getTppMessages()))).build();
    }

    private List<TppMessage500PIIS> mapToTppMessage500PIIS(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> ((TppMessage500PIIS.TppMessage500PIISBuilder)((TppMessage500PIIS.TppMessage500PIISBuilder)((TppMessage500PIIS.TppMessage500PIISBuilder)((TppMessage500PIIS.TppMessage500PIISBuilder)TppMessage500PIIS.builder().category(TppMessageCategory.fromValue((String)m.getCategory().name()))).code(m.getMessageErrorCode().getName())).path(m.getPath())).text(this.getErrorText((TppMessageInformation)m))).build()).collect(Collectors.toList());
    }
}

