/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.processor.service;

import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.domain.authorisation.CommonAuthorisationParameters;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.authorization.processor.service.AuthorisationProcessorService;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseAuthorisationProcessorService
implements AuthorisationProcessorService {
    private static final Logger log = LoggerFactory.getLogger(BaseAuthorisationProcessorService.class);
    private static final String UNSUPPORTED_ERROR_MESSAGE = "Current SCA status is not supported";

    BaseAuthorisationProcessorService() {
    }

    @Override
    public AuthorisationProcessorResponse doScaStarted(AuthorisationProcessorRequest authorisationProcessorRequest) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    @Override
    public AuthorisationProcessorResponse doScaFailed(AuthorisationProcessorRequest authorisationProcessorRequest) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    @Override
    public AuthorisationProcessorResponse doScaExempted(AuthorisationProcessorRequest authorisationProcessorRequest) {
        throw new UnsupportedOperationException(UNSUPPORTED_ERROR_MESSAGE);
    }

    boolean isPsuExist(PsuIdData psuIdData) {
        return Optional.ofNullable(psuIdData).map(PsuIdData::isNotEmpty).orElse(false);
    }

    boolean isSingleScaMethod(List<AuthenticationObject> spiScaMethods) {
        return spiScaMethods.size() == 1;
    }

    boolean isMultipleScaMethods(List<AuthenticationObject> spiScaMethods) {
        return spiScaMethods.size() > 1;
    }

    ChallengeData mapToChallengeData(SpiAuthorizationCodeResult authorizationCodeResult) {
        if (authorizationCodeResult == null || authorizationCodeResult.isEmpty()) {
            return null;
        }
        return authorizationCodeResult.getChallengeData();
    }

    PsuIdData extractPsuIdData(CommonAuthorisationParameters request, Authorisation authorisation) {
        PsuIdData psuDataInRequest = request.getPsuData();
        return this.isPsuExist(psuDataInRequest) ? psuDataInRequest : authorisation.getPsuIdData();
    }
}

