/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.consent.CmsCreateConsentResponse;
import de.adorsys.psd2.consent.api.service.ConsentServiceEncrypted;
import de.adorsys.psd2.xs2a.domain.Xs2aResponse;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CmsCreateConsentResponseService {
    private static final Logger log = LoggerFactory.getLogger(CmsCreateConsentResponseService.class);
    private final ConsentServiceEncrypted consentService;

    public Xs2aResponse<CmsCreateConsentResponse> getCmsCreateConsentResponse(CmsConsent cmsConsent) {
        CmsResponse response;
        try {
            response = this.consentService.createConsent(cmsConsent);
        }
        catch (WrongChecksumException e) {
            log.info("Consent cannot be created, checksum verification failed");
            return Xs2aResponse.builder().build();
        }
        if (response.hasError()) {
            log.info("Consent cannot be created, because can't save to cms DB");
            return Xs2aResponse.builder().build();
        }
        return Xs2aResponse.builder().payload((CmsCreateConsentResponse)response.getPayload()).build();
    }

    @ConstructorProperties(value={"consentService"})
    public CmsCreateConsentResponseService(ConsentServiceEncrypted consentService) {
        this.consentService = consentService;
    }
}

