/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.IBANValidator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IbanValidator {
    private static final Logger log = LoggerFactory.getLogger(IbanValidator.class);
    private final AspspProfileServiceWrapper aspspProfileService;
    private final ErrorBuildingService errorBuildingService;

    public void validate(String iban, @NotNull MessageError messageError) {
        if (this.aspspProfileService.isIbanValidationDisabled()) {
            log.info("IBAN validation is disabled.");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)iban) && !this.isValidIban(iban)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_INVALID_FIELD, (Object[])new Object[]{"IBAN"}));
        }
    }

    private boolean isValidIban(String iban) {
        IBANValidator validator = IBANValidator.getInstance();
        return validator.isValid(iban);
    }

    @ConstructorProperties(value={"aspspProfileService", "errorBuildingService"})
    public IbanValidator(AspspProfileServiceWrapper aspspProfileService, ErrorBuildingService errorBuildingService) {
        this.aspspProfileService = aspspProfileService;
        this.errorBuildingService = errorBuildingService;
    }
}

