/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.validator.payment.config.ValidationObject;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.beans.ConstructorProperties;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FieldLengthValidator {
    private final ErrorBuildingService errorBuildingService;

    public void checkFieldForMaxLength(String fieldToCheck, String fieldName, ValidationObject validationObject, MessageError messageError) {
        if (this.isFieldExtra(validationObject, fieldToCheck)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_EXTRA_FIELD, (Object[])new Object[]{fieldName}));
            return;
        }
        if (this.isFieldMissing(validationObject, fieldToCheck)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_EMPTY_FIELD, (Object[])new Object[]{fieldName}));
            return;
        }
        if (this.isFieldPresent(validationObject, fieldToCheck)) {
            this.checkFieldForMaxLength(fieldToCheck, fieldName, validationObject.getMaxLength(), messageError);
        }
    }

    private void checkFieldForMaxLength(@NotNull String fieldToCheck, String fieldName, int maxLength, MessageError messageError) {
        if (fieldToCheck.length() > maxLength) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_OVERSIZE_FIELD, (Object[])new Object[]{fieldName, maxLength}));
        }
    }

    private boolean isFieldExtra(ValidationObject validationObject, String fieldToCheck) {
        return validationObject.isNone() && Objects.nonNull(fieldToCheck);
    }

    private boolean isFieldMissing(ValidationObject validationObject, String fieldToCheck) {
        return validationObject.isRequired() && StringUtils.isBlank((CharSequence)fieldToCheck);
    }

    private boolean isFieldPresent(ValidationObject validationObject, String fieldToCheck) {
        boolean isNotExtra = validationObject.isRequired() || validationObject.isOptional();
        return isNotExtra && StringUtils.isNotBlank((CharSequence)fieldToCheck);
    }

    @ConstructorProperties(value={"errorBuildingService"})
    public FieldLengthValidator(ErrorBuildingService errorBuildingService) {
        this.errorBuildingService = errorBuildingService;
    }
}

