/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Authorisations;
import de.adorsys.psd2.model.AuthorisationsList;
import de.adorsys.psd2.model.ConsentInformationResponse200Json;
import de.adorsys.psd2.model.ConsentStatus;
import de.adorsys.psd2.model.ConsentStatusResponse200;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.model.ConsentsResponse201;
import de.adorsys.psd2.model.ScaStatus;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppNotificationData;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorisationsParameters;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPaymentCancellationAuthorisationSubResource;
import de.adorsys.psd2.xs2a.domain.consent.pis.PaymentAuthorisationParameters;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.ScaMethodsMapper;
import de.adorsys.psd2.xs2a.web.mapper.TppMessageGenericMapper;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Component;

@Component
public class ConsentModelMapper {
    private final Xs2aObjectMapper xs2aObjectMapper;
    public final AccountModelMapper accountModelMapper;
    private final HrefLinkMapper hrefLinkMapper;
    private final ScaMethodsMapper scaMethodsMapper;
    private final TppMessageGenericMapper tppMessageGenericMapper;
    private final CoreObjectsMapper coreObjectsMapper;

    public CreateConsentReq mapToCreateConsentReq(Consents consent, TppRedirectUri tppRedirectUri, TppNotificationData tppNotificationData, String tppBrandLoggingInformation, String instanceId) {
        return Optional.ofNullable(consent).map(cnst -> {
            CreateConsentReq createConsentReq = new CreateConsentReq();
            createConsentReq.setAccess(this.mapToAccountAccessInner(cnst.getAccess()));
            createConsentReq.setRecurringIndicator(cnst.getRecurringIndicator());
            createConsentReq.setValidUntil(cnst.getValidUntil());
            createConsentReq.setFrequencyPerDay(cnst.getFrequencyPerDay());
            createConsentReq.setCombinedServiceIndicator(BooleanUtils.toBoolean((Boolean)cnst.isCombinedServiceIndicator()));
            createConsentReq.setTppRedirectUri(tppRedirectUri);
            createConsentReq.setTppNotificationData(tppNotificationData);
            createConsentReq.setAvailableAccounts(this.mapToAccountAccessTypeFromAvailableAccounts(cnst.getAccess().getAvailableAccounts()));
            createConsentReq.setAllPsd2(this.mapToAccountAccessTypeFromAllPsd2Enum(cnst.getAccess().getAllPsd2()));
            createConsentReq.setAvailableAccountsWithBalance(this.mapToAccountAccessTypeFromAvailableAccountsWithBalance(cnst.getAccess().getAvailableAccountsWithBalance()));
            createConsentReq.setTppBrandLoggingInformation(tppBrandLoggingInformation);
            createConsentReq.setInstanceId(instanceId);
            return createConsentReq;
        }).orElse(null);
    }

    public ConsentStatusResponse200 mapToConsentStatusResponse200(ConsentStatusResponse consentStatusResponse) {
        return Optional.ofNullable(consentStatusResponse).map(cstr -> {
            ConsentStatusResponse200 response200 = new ConsentStatusResponse200();
            response200.setConsentStatus(ConsentStatus.fromValue((String)cstr.getConsentStatus()));
            response200.setPsuMessage(cstr.getPsuMessage());
            return response200;
        }).orElse(null);
    }

    public ConsentsResponse201 mapToConsentsResponse201(CreateConsentResponse createConsentResponse) {
        return Optional.ofNullable(createConsentResponse).map(cnst -> new ConsentsResponse201().consentStatus(ConsentStatus.fromValue((String)cnst.getConsentStatus())).consentId(cnst.getConsentId()).scaMethods(this.scaMethodsMapper.mapToScaMethods(cnst.getScaMethods())).scaStatus((ScaStatus)Optional.ofNullable(cnst.getScaStatus()).map(this.coreObjectsMapper::mapToModelScaStatus).orElse(null))._links(this.hrefLinkMapper.mapToLinksMap(cnst.getLinks())).psuMessage(cnst.getPsuMessage()).tppMessages(this.tppMessageGenericMapper.mapToTppMessageGenericList(cnst.getTppMessageInformation()))).orElse(null);
    }

    public ConsentInformationResponse200Json mapToConsentInformationResponse200Json(AisConsent aisConsent) {
        return Optional.ofNullable(aisConsent).map(consent -> new ConsentInformationResponse200Json().access(this.mapToAccountAccessDomain((AisConsent)consent)).recurringIndicator(Boolean.valueOf(consent.isRecurringIndicator())).validUntil(consent.getValidUntil()).frequencyPerDay(consent.getFrequencyPerDay()).lastActionDate(consent.getLastActionDate()).consentStatus(ConsentStatus.fromValue((String)consent.getConsentStatus().getValue()))).orElse(null);
    }

    private AccountAccess mapToAccountAccessInner(de.adorsys.psd2.model.AccountAccess accountAccess) {
        return Optional.ofNullable(accountAccess).map(acs -> new AccountAccess(this.mapToXs2aAccountReferences(acs.getAccounts()), this.mapToXs2aAccountReferences(acs.getBalances()), this.mapToXs2aAccountReferences(acs.getTransactions()), this.mapToAdditionalInformationAccess(acs.getAdditionalInformation()))).orElse(null);
    }

    private AdditionalInformationAccess mapToAdditionalInformationAccess(de.adorsys.psd2.model.AdditionalInformationAccess additionalInformationAccess) {
        return Optional.ofNullable(additionalInformationAccess).map(info -> new AdditionalInformationAccess(this.mapToXs2aAccountReferencesOrDefault(info.getOwnerName(), null), this.mapToXs2aAccountReferencesOrDefault(info.getTrustedBeneficiaries(), null))).orElse(null);
    }

    private de.adorsys.psd2.model.AccountAccess mapToAccountAccessDomain(AisConsent aisConsent) {
        AccountAccess accountAccess = aisConsent.getAccess();
        AisConsentData consentData = (AisConsentData)aisConsent.getConsentData();
        return Optional.ofNullable(accountAccess).map(access -> {
            de.adorsys.psd2.model.AccountAccess mappedAccountAccess = new de.adorsys.psd2.model.AccountAccess();
            mappedAccountAccess.setAccounts(this.accountModelMapper.mapToAccountReferences(access.getAccounts()));
            mappedAccountAccess.setBalances(this.accountModelMapper.mapToAccountReferences(access.getBalances()));
            mappedAccountAccess.setTransactions(this.accountModelMapper.mapToAccountReferences(access.getTransactions()));
            mappedAccountAccess.setAvailableAccounts(AccountAccess.AvailableAccountsEnum.fromValue((String)Optional.ofNullable(consentData.getAvailableAccounts()).map(AccountAccessType::getDescription).orElse(null)));
            mappedAccountAccess.setAllPsd2(AccountAccess.AllPsd2Enum.fromValue((String)Optional.ofNullable(consentData.getAllPsd2()).map(AccountAccessType::getDescription).orElse(null)));
            mappedAccountAccess.setAvailableAccountsWithBalance(AccountAccess.AvailableAccountsWithBalanceEnum.fromValue((String)Optional.ofNullable(consentData.getAvailableAccountsWithBalance()).map(AccountAccessType::getDescription).orElse(null)));
            mappedAccountAccess.setAdditionalInformation(this.mapToAdditionalInformationAccess(access.getAdditionalInformationAccess()));
            return mappedAccountAccess;
        }).orElse(null);
    }

    private de.adorsys.psd2.model.AdditionalInformationAccess mapToAdditionalInformationAccess(AdditionalInformationAccess additionalInformationAccess) {
        return Optional.ofNullable(additionalInformationAccess).map(info -> {
            if (info.noAdditionalInformationAccess()) {
                return null;
            }
            de.adorsys.psd2.model.AdditionalInformationAccess informationAccess = new de.adorsys.psd2.model.AdditionalInformationAccess();
            informationAccess.setOwnerName(this.accountModelMapper.mapToAccountReferences(info.getOwnerName()));
            informationAccess.setTrustedBeneficiaries(this.accountModelMapper.mapToAccountReferences(info.getTrustedBeneficiaries()));
            return informationAccess;
        }).orElse(null);
    }

    private AccountAccessType mapToAccountAccessTypeFromAvailableAccounts(AccountAccess.AvailableAccountsEnum accountsEnum) {
        return Optional.ofNullable(accountsEnum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    private AccountAccessType mapToAccountAccessTypeFromAllPsd2Enum(AccountAccess.AllPsd2Enum allPsd2Enum) {
        return Optional.ofNullable(allPsd2Enum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    private AccountAccessType mapToAccountAccessTypeFromAvailableAccountsWithBalance(AccountAccess.AvailableAccountsWithBalanceEnum accountsEnum) {
        return Optional.ofNullable(accountsEnum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    public List<de.adorsys.psd2.xs2a.core.profile.AccountReference> mapToXs2aAccountReferences(List<AccountReference> references) {
        return this.mapToXs2aAccountReferencesOrDefault(references, Collections.emptyList());
    }

    private List<de.adorsys.psd2.xs2a.core.profile.AccountReference> mapToXs2aAccountReferencesOrDefault(List<AccountReference> references, List<de.adorsys.psd2.xs2a.core.profile.AccountReference> defaultValue) {
        return Optional.ofNullable(references).map(ref -> ref.stream().map(this::mapToAccountReference).collect(Collectors.toList())).orElse(defaultValue);
    }

    public de.adorsys.psd2.xs2a.core.profile.AccountReference mapToAccountReference(Object reference) {
        return (de.adorsys.psd2.xs2a.core.profile.AccountReference)this.xs2aObjectMapper.convertValue(reference, de.adorsys.psd2.xs2a.core.profile.AccountReference.class);
    }

    public ConsentAuthorisationsParameters mapToUpdatePsuData(PsuIdData psuData, String consentId, String authorizationId, Map body) {
        ConsentAuthorisationsParameters updatePsuData = new ConsentAuthorisationsParameters();
        updatePsuData.setPsuData(psuData);
        updatePsuData.setConsentId(consentId);
        updatePsuData.setAuthorizationId(authorizationId);
        updatePsuData.setAuthorisationType(AuthorisationType.CONSENT);
        if (body != null && !body.isEmpty()) {
            Optional.ofNullable(body.get("psuData")).map(Map.class::cast).ifPresent(psuDataMap -> updatePsuData.setPassword((String)psuDataMap.get("password")));
            Optional.ofNullable(body.get("authenticationMethodId")).map(String.class::cast).ifPresent(updatePsuData::setAuthenticationMethodId);
            Optional.ofNullable(body.get("scaAuthenticationData")).map(String.class::cast).ifPresent(updatePsuData::setScaAuthenticationData);
            Optional.ofNullable(body.get("confirmationCode")).map(String.class::cast).ifPresent(updatePsuData::setConfirmationCode);
        } else {
            updatePsuData.setUpdatePsuIdentification(true);
        }
        return updatePsuData;
    }

    public Authorisations mapToAuthorisations(Xs2aPaymentCancellationAuthorisationSubResource idsContainer) {
        return Optional.ofNullable(idsContainer.getAuthorisationIds()).map(this::buildAuthorisations).orElseGet(Authorisations::new);
    }

    public PaymentAuthorisationParameters mapToPisUpdatePsuData(PsuIdData psuData, String paymentId, String authorisationId, PaymentType paymentService, String paymentProduct, Map body) {
        PaymentAuthorisationParameters request = new PaymentAuthorisationParameters();
        request.setPsuData(psuData);
        request.setPaymentId(paymentId);
        request.setAuthorisationId(authorisationId);
        request.setPaymentService(paymentService);
        request.setPaymentProduct(paymentProduct);
        if (body != null && !body.isEmpty()) {
            Optional.ofNullable(body.get("psuData")).map(Map.class::cast).ifPresent(psuDataMap -> request.setPassword((String)psuDataMap.get("password")));
            Optional.ofNullable(body.get("authenticationMethodId")).map(String.class::cast).ifPresent(request::setAuthenticationMethodId);
            Optional.ofNullable(body.get("scaAuthenticationData")).ifPresent(authData -> request.setScaAuthenticationData((String)authData));
            Optional.ofNullable(body.get("confirmationCode")).ifPresent(code -> request.setConfirmationCode((String)code));
        } else {
            request.setUpdatePsuIdentification(true);
        }
        return request;
    }

    private Authorisations buildAuthorisations(List<String> authorisationIds) {
        Authorisations authorisations = new Authorisations();
        AuthorisationsList authorisationsList = new AuthorisationsList();
        authorisationsList.addAll(authorisationIds);
        authorisations.setAuthorisationIds(authorisationsList);
        return authorisations;
    }

    @ConstructorProperties(value={"xs2aObjectMapper", "accountModelMapper", "hrefLinkMapper", "scaMethodsMapper", "tppMessageGenericMapper", "coreObjectsMapper"})
    public ConsentModelMapper(Xs2aObjectMapper xs2aObjectMapper, AccountModelMapper accountModelMapper, HrefLinkMapper hrefLinkMapper, ScaMethodsMapper scaMethodsMapper, TppMessageGenericMapper tppMessageGenericMapper, CoreObjectsMapper coreObjectsMapper) {
        this.xs2aObjectMapper = xs2aObjectMapper;
        this.accountModelMapper = accountModelMapper;
        this.hrefLinkMapper = hrefLinkMapper;
        this.scaMethodsMapper = scaMethodsMapper;
        this.tppMessageGenericMapper = tppMessageGenericMapper;
        this.coreObjectsMapper = coreObjectsMapper;
    }
}

