/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aConfirmationOfFundsResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import de.adorsys.psd2.xs2a.web.link.holder.LinkParameters;

public class CreatePiisConsentLinks
extends AbstractLinks {
    private final ScaApproachResolver scaApproachResolver;
    private final RedirectLinkBuilder redirectLinkBuilder;
    private final RedirectIdService redirectIdService;
    private final ScaRedirectFlow scaRedirectFlow;
    private final LinkParameters linkParameters;

    public CreatePiisConsentLinks(LinkParameters linkParameters, ScaApproachResolver scaApproachResolver, Xs2aConfirmationOfFundsResponse response, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, ScaRedirectFlow scaRedirectFlow) {
        super(linkParameters.getHttpUrl());
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.redirectIdService = redirectIdService;
        this.scaRedirectFlow = scaRedirectFlow;
        this.linkParameters = linkParameters;
        this.buildConsentLinks(response);
    }

    private void buildConsentLinks(Xs2aConfirmationOfFundsResponse response) {
        ScaApproach scaApproach;
        String consentId = response.getConsentId();
        this.setSelf(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}", consentId));
        this.setStatus(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/status", consentId));
        String authorisationId = response.getAuthorizationId();
        ScaApproach scaApproach2 = scaApproach = authorisationId == null ? this.scaApproachResolver.resolveScaApproach() : this.scaApproachResolver.getScaApproach(authorisationId);
        if (scaApproach == ScaApproach.EMBEDDED) {
            this.addEmbeddedRelatedLinks(consentId, authorisationId);
        } else if (scaApproach == ScaApproach.REDIRECT) {
            this.addRedirectRelatedLinks(response, consentId, authorisationId);
        } else if (scaApproach == ScaApproach.DECOUPLED) {
            this.addDecoupledRelatedLinks(consentId, authorisationId);
        }
    }

    private void addRedirectRelatedLinks(Xs2aConfirmationOfFundsResponse response, String consentId, String authorisationId) {
        if (this.linkParameters.isExplicitMethod()) {
            this.setStartAuthorisation(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations", consentId));
        } else {
            String redirectId = this.redirectIdService.generateRedirectId(authorisationId);
            String consentOauthLink = this.scaRedirectFlow == ScaRedirectFlow.OAUTH ? this.redirectLinkBuilder.buildConsentScaOauthRedirectLink(consentId, redirectId, response.getInternalRequestId()) : this.redirectLinkBuilder.buildConsentScaRedirectLink(consentId, redirectId, response.getInternalRequestId(), this.linkParameters.getInstanceId(), ConsentType.PIIS_TPP);
            this.setScaRedirect(new HrefType(consentOauthLink));
            this.setScaStatus(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
            if (this.linkParameters.isAuthorisationConfirmationRequestMandated()) {
                this.setConfirmation(this.buildPath(this.redirectLinkBuilder.buildConfirmationLink(consentId, redirectId, ConsentType.PIIS_TPP), new Object[0]));
            }
        }
    }

    private void addDecoupledRelatedLinks(String consentId, String authorisationId) {
        if (this.linkParameters.isExplicitMethod()) {
            this.setStartAuthorisation(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations", consentId));
        } else {
            this.setScaStatus(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
        }
    }

    private void addEmbeddedRelatedLinks(String consentId, String authorizationId) {
        if (this.linkParameters.isExplicitMethod()) {
            if (this.linkParameters.isSigningBasketModeActive()) {
                this.setStartAuthorisation(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations", consentId));
            } else {
                this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations", consentId));
            }
        } else {
            this.setScaStatus(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
            this.setUpdatePsuAuthentication(this.buildPath("/v2/consents/confirmation-of-funds/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
        }
    }
}

