/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import de.adorsys.psd2.xs2a.web.link.holder.LinkParameters;

public class CreateConsentLinks
extends AbstractLinks {
    private final ScaApproachResolver scaApproachResolver;
    private final RedirectLinkBuilder redirectLinkBuilder;
    private final RedirectIdService redirectIdService;
    private final ScaRedirectFlow scaRedirectFlow;
    private final LinkParameters linkParameters;

    public CreateConsentLinks(LinkParameters linkParameters, ScaApproachResolver scaApproachResolver, CreateConsentResponse response, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, ScaRedirectFlow scaRedirectFlow) {
        super(linkParameters.getHttpUrl());
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.redirectIdService = redirectIdService;
        this.linkParameters = linkParameters;
        this.scaRedirectFlow = scaRedirectFlow;
        this.buildConsentLinks(response);
    }

    private void buildConsentLinks(CreateConsentResponse response) {
        ScaApproach scaApproach;
        String consentId = response.getConsentId();
        String authorisationId = response.getAuthorizationId();
        this.setSelf(this.buildPath("/v1/consents/{consentId}", consentId));
        this.setStatus(this.buildPath("/v1/consents/{consentId}/status", consentId));
        ScaApproach scaApproach2 = scaApproach = authorisationId == null ? this.scaApproachResolver.resolveScaApproach() : this.scaApproachResolver.getScaApproach(authorisationId);
        if (scaApproach == ScaApproach.EMBEDDED) {
            this.buildLinkForEmbeddedScaApproach(consentId, authorisationId);
        } else if (scaApproach == ScaApproach.REDIRECT) {
            this.buildLinkForRedirectScaApproach(consentId, authorisationId, response);
        } else if (scaApproach == ScaApproach.DECOUPLED) {
            this.buildLinkForDecoupledScaApproach(consentId, authorisationId);
        }
    }

    private void buildLinkForEmbeddedScaApproach(String consentId, String authorizationId) {
        if (this.linkParameters.isExplicitMethod()) {
            if (this.linkParameters.isSigningBasketModeActive()) {
                this.setStartAuthorisation(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
            } else {
                this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
            }
        } else {
            this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
            this.setUpdatePsuAuthentication(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
        }
    }

    private void buildLinkForRedirectScaApproach(String consentId, String authorisationId, CreateConsentResponse response) {
        if (this.linkParameters.isExplicitMethod()) {
            this.setStartAuthorisation(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
        } else {
            String redirectId = this.redirectIdService.generateRedirectId(authorisationId);
            String consentOauthLink = this.scaRedirectFlow == ScaRedirectFlow.OAUTH ? this.redirectLinkBuilder.buildConsentScaOauthRedirectLink(consentId, redirectId, response.getInternalRequestId()) : this.redirectLinkBuilder.buildConsentScaRedirectLink(consentId, redirectId, response.getInternalRequestId(), this.linkParameters.getInstanceId(), ConsentType.AIS);
            this.setScaRedirect(new HrefType(consentOauthLink));
            this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
            if (this.linkParameters.isAuthorisationConfirmationRequestMandated()) {
                this.setConfirmation(this.buildPath(this.redirectLinkBuilder.buildConfirmationLink(consentId, redirectId, ConsentType.AIS), new Object[0]));
            }
        }
    }

    private void buildLinkForDecoupledScaApproach(String consentId, String authorisationId) {
        if (this.linkParameters.isExplicitMethod()) {
            this.setStartAuthorisation(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
        } else {
            this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
        }
    }
}

